/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.vatreports;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaConfig;
import org.chorem.lima.business.DocumentServiceMonitorable;
import org.chorem.lima.business.HttpServerServiceMonitorable;
import org.chorem.lima.business.utils.DocumentsEnum;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.vatreports.VatReportTable;
import org.chorem.lima.ui.vatreports.VatReportTableModel;
import org.chorem.lima.ui.vatreports.VatReportView;

public class VatReportViewHandler {
    private static final Log log = LogFactory.getLog(VatReportViewHandler.class);
    protected VatReportView view;
    protected VatReportTable table;
    protected VatReportTableModel tableModel;
    protected DocumentServiceMonitorable documentService;
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    protected int port;

    protected VatReportViewHandler(VatReportView view) {
        this.view = view;
        this.port = LimaServiceFactory.getInstance().getService(HttpServerServiceMonitorable.class).getHttpPort();
        this.documentService = LimaServiceFactory.getInstance().getService(DocumentServiceMonitorable.class);
    }

    public VatReportView getView() {
        return this.view;
    }

    public void editVat() {
        if (this.tableModel.getBeginDate() != null || this.tableModel.getEndDate() != null) {
            String address = LimaConfig.getInstance().getHostAdress();
            try {
                String url = "http://" + address + ":" + this.port + "/?beginDate=" + dateFormat.format(this.tableModel.getBeginDate()) + "&endDate=" + dateFormat.format(this.tableModel.getEndDate()) + "&format=.pdf&model=" + DocumentsEnum.VAT.getFileName() + "&autocomplete=" + this.tableModel.getAutocomplete();
                Desktop.getDesktop().browse(new URI(url));
            }
            catch (IOException e) {
                log.error((Object)"Can't open browser", (Throwable)e);
            }
            catch (URISyntaxException e) {
                log.error((Object)"Can't create news URI", (Throwable)e);
            }
        }
    }

    public void refresh() {
        this.tableModel = this.view.getVatReportTableModel();
        this.tableModel.refresh();
    }
}

