/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialstatementreport;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.FiscalPeriodServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.utils.FormatsEnum;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.financialstatementreport.FinancialStatementReportTableModel;
import org.chorem.lima.ui.financialstatementreport.FinancialStatementReportView;
import org.chorem.lima.util.ErrorHelper;
import org.nuiton.i18n.I18n;

public class FinancialStatementReportViewHandler {
    private static final Log log = LogFactory.getLog(FinancialStatementReportViewHandler.class);
    protected FinancialStatementReportView view;
    protected FinancialStatementReportTableModel model;
    protected FiscalPeriodServiceMonitorable fiscalPeriodService;

    protected FinancialStatementReportViewHandler(FinancialStatementReportView view) {
        this.view = view;
        this.fiscalPeriodService = LimaServiceFactory.getInstance().getService(FiscalPeriodServiceMonitorable.class);
    }

    public void refresh() {
        this.model = this.view.getModelTable();
        this.model.refresh();
    }

    public FinancialStatementReportView getView() {
        return this.view;
    }

    public void createDocument() {
        this.model = this.view.getModelTable();
        Date selectedBeginDate = this.model.getBeginDate();
        Date selectedEndDate = this.model.getEndDate();
        if (selectedBeginDate != null && selectedEndDate != null) {
            List blockedFiscalPeriods = new ArrayList();
            try {
                blockedFiscalPeriods = this.fiscalPeriodService.getAllBlockedFiscalPeriods();
            }
            catch (LimaException eee) {
                if (log.isErrorEnabled()) {
                    log.debug((Object)"Enable to create document ", (Throwable)eee);
                }
                ErrorHelper.showErrorDialog("Enable to create document ", eee);
            }
            boolean error = true;
            for (FiscalPeriod blockedFiscalPeriod : blockedFiscalPeriods) {
                if (!blockedFiscalPeriod.getBeginDate().equals(selectedBeginDate) || !blockedFiscalPeriod.getEndDate().equals(selectedEndDate) || !blockedFiscalPeriod.getLocked()) continue;
                error = false;
            }
            if (error) {
                JOptionPane.showMessageDialog((Component)((Object)this.view), "Can't create document on an open fiscal year", I18n._((String)"lima.common.error", (Object[])new Object[0]), 0);
            } else {
                FormatsEnum selectedEnum = (FormatsEnum)this.view.getDocumentEditor().getSelectedItem();
                this.model.createDocument(selectedEnum);
            }
        }
    }
}

