/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.celleditor;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.TableCellEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaContext;

public class BigDecimalTableCellEditor
extends AbstractCellEditor
implements TableCellEditor,
FocusListener,
AncestorListener,
KeyListener {
    private static final Log log = LogFactory.getLog(BigDecimalTableCellEditor.class);
    private static final long serialVersionUID = 1L;
    protected final JTextField textField = new JTextField();
    private boolean keyPressed;

    public BigDecimalTableCellEditor() {
        this.textField.setEditable(true);
        this.textField.setHorizontalAlignment(4);
        this.textField.addFocusListener(this);
        this.textField.addAncestorListener(this);
        this.textField.addKeyListener(this);
        this.keyPressed = false;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.textField.setText(value.toString());
        return this.textField;
    }

    @Override
    public Object getCellEditorValue() {
        BigDecimal bdValue;
        block3: {
            String textValue = this.textField.getText().trim();
            if ((textValue = textValue.replaceAll(",", ".")).equals("")) {
                return BigDecimal.ZERO;
            }
            bdValue = BigDecimal.ZERO;
            try {
                bdValue = new BigDecimal(textValue);
            }
            catch (NumberFormatException eee) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)("Can't set " + textValue + " to a BigDecimal"), (Throwable)eee);
            }
        }
        bdValue = bdValue.setScale(LimaContext.getContext().getConfig().getScale(), 4);
        return bdValue;
    }

    @Override
    public boolean isCellEditable(EventObject evt) {
        return !(evt instanceof MouseEvent) || ((MouseEvent)evt).getClickCount() == 2;
    }

    @Override
    public void focusGained(FocusEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BigDecimalTableCellEditor.this.textField.selectAll();
            }
        });
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.keyPressed = false;
    }

    @Override
    public void ancestorAdded(AncestorEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BigDecimalTableCellEditor.this.textField.requestFocus();
            }
        });
    }

    @Override
    public void ancestorRemoved(AncestorEvent e) {
    }

    @Override
    public void ancestorMoved(AncestorEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (!this.keyPressed && this.textField.getSelectionStart() == 0 && this.textField.getSelectionEnd() == this.textField.getText().length()) {
            if (e.getKeyChar() == '\b') {
                this.textField.setText("");
                this.keyPressed = true;
            } else if (String.valueOf(e.getKeyChar()).matches("[a-zA-z0-9]")) {
                this.textField.setText(String.valueOf(e.getKeyChar()));
                this.keyPressed = true;
            }
        }
    }
}

