/*
 * #%L
 * Lima Swing
 * 
 * $Id: FinancialStatementChartViewHandler.java 3278 2011-08-16 14:09:44Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.5.1/lima-swing/src/main/java/org/chorem/lima/ui/financialstatementchart/FinancialStatementChartViewHandler.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.financialstatementchart;

import static org.nuiton.i18n.I18n._;

import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.FinancialStatementServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaBusinessException;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.entity.FinancialStatement;
import org.chorem.lima.entity.FinancialStatementImpl;
import org.chorem.lima.enums.FinancialStatementsChartEnum;
import org.chorem.lima.enums.ImportExportEnum;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.financialstatementchart.FinancialStatementHeaderForm;
import org.chorem.lima.ui.financialstatementchart.FinancialStatementMovementForm;
import org.chorem.lima.ui.importexport.ImportExport;
import org.chorem.lima.util.DialogHelper;
import org.chorem.lima.util.ErrorHelper;
import org.jdesktop.swingx.JXTreeTable;

/**
 * Handler associated with account view.
 * 
 * @author chatellier
 * @version $Revision: 3278 $
 * 
 * Last update : $Date: 2011-08-16 16:09:44 +0200 (Tue, 16 Aug 2011) $
 * By : $Author: tchemit $
 */
public class FinancialStatementChartViewHandler implements ServiceListener {

    /** log. */
    private static final Log log = LogFactory.getLog(FinancialStatementChartViewHandler.class);

    protected FinancialStatementServiceMonitorable financialStatementService;
    
    protected FinancialStatementChartView view;
                
    protected FinancialStatementChartViewHandler(FinancialStatementChartView view) {
        this.view = view;
        
        financialStatementService =
            LimaServiceFactory.getInstance().getService(
                    FinancialStatementServiceMonitorable.class);
        LimaServiceFactory.getInstance().getService(
                ImportServiceMonitorable.class).addListener(this);
    }

    /**
     * Add new account with account form.
     */
    public void addFinancialStatementHeader() {

        JXTreeTable treeTable = view.getTreeTable();
        FinancialStatementChartTreeTableModel treeTableModel =
            (FinancialStatementChartTreeTableModel) treeTable.getTreeTableModel();

        FinancialStatement newFinancialStatementHeader =
            new FinancialStatementImpl();
        FinancialStatementHeaderForm financialStatementHeaderForm =
            new FinancialStatementHeaderForm(view);
        financialStatementHeaderForm.setFinancialStatement(newFinancialStatementHeader);
        // jaxx constructor don't call super() ?
        financialStatementHeaderForm.setLocationRelativeTo(view);
        financialStatementHeaderForm.setVisible(true);
        
        // null == cancel action
        newFinancialStatementHeader = financialStatementHeaderForm.getFinancialStatement();
        if (newFinancialStatementHeader != null) {
            newFinancialStatementHeader.setHeader(true);
            // get current selection path
            TreePath treePath = null;
            int selectedRow = treeTable.getSelectedRow();
            if ( selectedRow != -1) {
                treePath = treeTable.getPathForRow(selectedRow);
            } else {
                treePath = new TreePath(treeTableModel.getRoot());
            }
            
            // add it
            try {
                treeTableModel.addFinancialStatement(treePath, newFinancialStatementHeader);
            } catch (LimaBusinessException eee) {
                if (log.isErrorEnabled()) {
                    log.error("Can't add financialStatementHeader", eee);
                }
                DialogHelper.showMessageDialog(eee.getMessage());

            } 
            
            catch (LimaException ex) {
                if (log.isErrorEnabled()) {
                    log.error("Can't add financialStatementHeader", ex);
                }
                ErrorHelper.showErrorDialog(_("lima.financialstatement.addfinancialStatementHeadererror"), ex);
            }
        }
    };
    
    public void addFinancialStatementMovement(){

         JXTreeTable treeTable = view.getTreeTable();
         FinancialStatementChartTreeTableModel treeTableModel =
             (FinancialStatementChartTreeTableModel) treeTable.getTreeTableModel();

        FinancialStatement newFinancialStatementMovement =
            new FinancialStatementImpl();
        FinancialStatementMovementForm financialStatementMovementForm =
            new FinancialStatementMovementForm(view);
        financialStatementMovementForm.setFinancialStatement(newFinancialStatementMovement);
         // jaxx constructor don't call super() ?
        financialStatementMovementForm.setLocationRelativeTo(view);
        financialStatementMovementForm.setVisible(true);
        newFinancialStatementMovement=financialStatementMovementForm.getFinancialStatement();
         
         // null == cancel action
         if (newFinancialStatementMovement != null) {
             // get current selection path
             TreePath treePath = null;
             int selectedRow = view.treeTable.getSelectedRow();
             treePath = view.treeTable.getPathForRow(selectedRow);
             // add it
             try {
                 treeTableModel.
                     addFinancialStatement(treePath, newFinancialStatementMovement);
             } catch (LimaBusinessException eee) {
                 if (log.isErrorEnabled()) {
                     log.error("Can't add FinancialStatementMovement", eee);
                 }
                 DialogHelper.showMessageDialog(eee.getMessage());
             } 
             
             catch (LimaException eee) {
                 if (log.isErrorEnabled()) {
                     log.error("Can't add FinancialStatementMovement", eee);
                 }
                 DialogHelper.showMessageDialog(eee.getMessage());
             }
         }
    }

    /**
     * Open account form with selected account.
     * Verifiy if it's an account or a subledger
     */
    public void updateFinancialStatement() {
        
         JXTreeTable treeTable = view.getTreeTable();
         FinancialStatementChartTreeTableModel treeTableModel =
             (FinancialStatementChartTreeTableModel) treeTable.getTreeTableModel();

        // get selected account
        int selectedRow = view.treeTable.getSelectedRow();
        TreePath treePath = view.treeTable.getPathForRow(selectedRow); // not null
        FinancialStatement financialStatement =
            (FinancialStatement) treePath.getLastPathComponent();   
        //update Account or update SubLedger
        if (financialStatement != null) {
            // get current selection path
            if ( selectedRow != -1) {
                treePath = view.treeTable.getPathForRow(selectedRow);
            } else {
                treePath = new TreePath(treeTableModel.getRoot());
            }
            //test if selectedrow is account or ledger
            log.debug(financialStatement.getHeader());
            if (financialStatement.getHeader()){
                FinancialStatementHeaderForm financialStatementHeaderForm =
                    new FinancialStatementHeaderForm(view);
                financialStatementHeaderForm.setFinancialStatement(financialStatement);
                // jaxx constructor don't call super() ?
                financialStatementHeaderForm.setLocationRelativeTo(view);
                financialStatementHeaderForm.setVisible(true);
                // null == cancel action
                financialStatement = financialStatementHeaderForm.getFinancialStatement();
                }
            // else is a movement
            else{
                FinancialStatementMovementForm financialStatementMovementForm =
                    new FinancialStatementMovementForm(view);
                financialStatementMovementForm.setFinancialStatement(financialStatement);
                // jaxx constructor don't call super() ?
                financialStatementMovementForm.setLocationRelativeTo(view);
                financialStatementMovementForm.setVisible(true);
                // null == cancel action
                financialStatement =
                    financialStatementMovementForm.getFinancialStatement();
            }
            //if action confirmed
            if (financialStatement != null){
                // update it
                try {
                    treeTableModel.updateFinancialStatement(
                            treePath, financialStatement);
                } catch (LimaException eee) {
                    if (log.isErrorEnabled()) {
                        log.error("Can't add update", eee);
                    }
                    DialogHelper.showMessageDialog(eee.getMessage());
                }
            }
        }
    }

    /**
     * Ask for user to remove for selected account, and remove it if confirmed.
     */
    public void removeFinancialStatement() {
         JXTreeTable treeTable = view.getTreeTable();
         FinancialStatementChartTreeTableModel treeTableModel =
             (FinancialStatementChartTreeTableModel) treeTable.getTreeTableModel();

        // Any row selected
        int selectedRow = view.treeTable.getSelectedRow();
        if ( selectedRow != -1) {
            int n = JOptionPane.showConfirmDialog(view,
                    _("lima.charts.account.question.remove"),
                    _("lima.common.confirmation"),
                    JOptionPane.YES_NO_OPTION,
                    JOptionPane.QUESTION_MESSAGE);
            if (n == JOptionPane.YES_OPTION) {
                // update view of treetable
                TreePath treePath = view.treeTable.getPathForRow(selectedRow);
                FinancialStatement financialStatement =
                    (FinancialStatement) treePath.getLastPathComponent();

                try{
                    treeTableModel.removeFinancialStatementObject(
                            treePath, financialStatement);
                } catch (LimaException eee) {
                    if (log.isErrorEnabled()) {
                        log.error("Can't delete account", eee);
                    }
                    DialogHelper.showMessageDialog(eee.getMessage());
                }
            }
        }
    }
    
    public void refresh(){
            JXTreeTable treeTable = view.getTreeTable();
         FinancialStatementChartTreeTableModel treeTableModel =
             (FinancialStatementChartTreeTableModel) treeTable.getTreeTableModel();
         try {
            treeTableModel.refreshTree();
        } catch (LimaException eee) {
            if(log.isDebugEnabled()){
                log.debug("Can't refresh model", eee);
            }
        }
        //refresh view
        view.repaint();
    }
    
    public void importFinancialStatementChart(){
        FinancialStatementImportForm form =
            new FinancialStatementImportForm(); 
        form.setLocationRelativeTo(view);
        form.setVisible(true);

        Object value = form.getRadioButtons().getSelectedValue();
        // if action confirmed
        if (value != null){
            if (form.getDeleteFinancialStatementChart().isSelected()){
                try {
                    financialStatementService.removeAllFinancialStatement();
                    
                } catch (LimaException eee) {
                    if (log.isDebugEnabled()){
                        log.debug("Can't delete financial statement chart", eee);
                    }
                }
            }
            FinancialStatementsChartEnum defaultFinancialStatementsEnum = 
                (FinancialStatementsChartEnum) value;
            ImportExport importExport = ImportExport.getInstance(view);
            importExport.importExport(ImportExportEnum.CSV_FINANCIALSTATEMENTS_IMPORT,
                    defaultFinancialStatementsEnum.getFilePath(), true);
        }
    }
    
    
    public void financialStatementChartCheck(){
        String result;
        try {
            result = financialStatementService.checkFinancialStatementChart();
            DialogHelper.showReportDialog(result, _("lima.financialstatement.check"), view);

        } catch (LimaException e) {
            log.error("Can't check financialstatement chart",e);
        }

    }
    
    @Override
    public void notifyMethod(String serviceName, String methodName) {
        
        if (methodName.contains("FinancialStatements")
                || methodName.contains("importAll")
                || methodName.contains("importAs")){
            refresh();
        }
    }
    
}
