/*
 * #%L
 * Lima :: Swing
 * 
 * $Id: BigDecimalTableCellRenderer.java 3278 2011-08-16 14:09:44Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.5.1/lima-swing/src/main/java/org/chorem/lima/ui/celleditor/BigDecimalTableCellRenderer.java $
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.celleditor;

import java.awt.Component;
import java.awt.Font;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;

import org.chorem.lima.LimaConfig;
import org.chorem.lima.LimaContext;
import org.chorem.lima.beans.FinancialStatementAmounts;
import org.chorem.lima.ui.financialstatementreport.FinancialStatementReportTableModel;

public class BigDecimalTableCellRenderer extends DefaultTableCellRenderer {

    private static final long serialVersionUID = -2499433026151065390L;
    
    public BigDecimalTableCellRenderer() {
        //
    }

	public Component getTableCellRendererComponent(JTable table, Object value,
        boolean isSelected, boolean hasFocus, int row, int column)
    {

        Component cell = super.getTableCellRendererComponent(
                table, value, isSelected, hasFocus, row, column);
        setHorizontalAlignment(SwingConstants.RIGHT);
        setValue(value);
        return this;
    }
    
    public void setValue(Object aValue) {
        Object result = aValue;
        if (( aValue != null) && (aValue instanceof BigDecimal)) {
            LimaConfig config = LimaContext.getContext().getConfig();
            String scale = "";
            for (int i = 0; i < config.getScale(); i++) {
                scale += "0";
            }
            DecimalFormat formatter = new DecimalFormat("##0." + scale);
            DecimalFormatSymbols symbol = new DecimalFormatSymbols();
            //set decimalSeparator and thousandSeparator preferences
            symbol.setDecimalSeparator(config.getDecimalSeparator());
            symbol.setGroupingSeparator(config.getThousandSeparator());
            formatter.setDecimalFormatSymbols(symbol);
            //always set grouping
            formatter.setGroupingUsed(true);
            formatter.setGroupingSize(3);
            result = formatter.format(result);
        } 
        super.setValue(result);
    }

}
