/*
 * #%L
 * Lima Swing
 * 
 * $Id: FiscalPeriodTable.java 3051 2010-11-29 14:57:16Z echatellier $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.4.3/lima-swing/src/main/java/org/chorem/lima/ui/fiscalperiod/FiscalPeriodTable.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.fiscalperiod;

import java.awt.Color;
import java.awt.Component;
import org.chorem.lima.entity.FiscalPeriod;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;

public class FiscalPeriodTable extends JXTable {

    private static final long serialVersionUID = -8462838870024505659L;

    protected FiscalPeriodViewHandler handler;
    
    protected FiscalPeriodTableModel model;
        
    private Highlighter colorTransaction;
    
    public FiscalPeriodTable(FiscalPeriodViewHandler handler) {

        this.handler = handler;
        model = this.handler.getView().getModelFiscalPeriodTable();

        //highlight financial financial transactions
        addBlockColor();
    }

    protected void addBlockColor() {
        HighlightPredicate predicate = new HighlightPredicate() {
            @Override
            public boolean isHighlighted(Component renderer,
                    ComponentAdapter adapter) {
                FiscalPeriod fiscalPeriod = (FiscalPeriod) model.getElementAt(adapter.row);
                // true if locked 
                return (fiscalPeriod.getLocked());
            }
        };
         colorTransaction =
             new ColorHighlighter(predicate, null, new Color(222,0,0));
         addHighlighter(colorTransaction);
     }
    
}
