/*
 * #%L
 * Lima :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.accountsreports;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.enums.ComboBoxDatesEnum;
import org.chorem.lima.ui.accountsreports.*;
import org.chorem.lima.ui.accountsreports.AccountComboBox;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class AccountsReportsView extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_PERIOD_COMBO_BOX = "periodComboBox";
    public static final String PROPERTY_SELECTED_ROW = "selectedRow";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVz28TRxSeuDjBcUKhKYRACil1K7Vq16QHpCo/IDGKksgpIUYoqi+d3R3FE8Yz25nZetsD4k/gT4A7l0q9cUI99MyBS9V/oao4cK14M7ve9dpOA7Elr73z3vve97558+bZP6ioJPr0EEeRI0OuaZs422v7+3fcQ+Lp20R5kgZaSBR/xgqo0ERlP11XGn3WrJvwahJerYl2IDjhPdFLdTSp9C+MqBYhWqNP8hGeUtVGal6KglB2UVNSw1CfvP638Nh/9LSAUBQAu1koZeG4qKySU3VUoL5GH0Gmn3GVYX4ANCTlB8B32qzVGFbqe9wmP6GHaKKOxgMsAUyja+9essWw8VGg0UTlHnYZua7RDSEPHK8lJGk7jLaxE1IHe54ASCVJIKRWzlryvhe/36ekEwQWbBygWpj7jEiNVk4GtRnHZ4hlRRjsOvH3REejc0YBx6jirAvBCOaZ51xb+IT1YdrKNFp+fzY2csdAZilmKg0r5RanmmJGfyUSVPvCbq8HelOg7sRqOwOe/wuzaEyzPULGe7Ko0cVc86gOtIJjbcazlAacCYikwoddd8W6iDQ6b6SKkoDt7rrxvpQGXav0Fb1rQRoES6+1izlhUF7t/bUbgMmn/TgJb9itFbKOXcKg53OM7WK+xnIlreO6WbqaN59ysfcA1M3BrIdaC97nyEmkzf+v8uvTlW3YGMGY4QyVz+aQMlM+qltNX8tdNrIdwlR6oEUQY0TO9n66dd9kAJU6VYkYVHDbc5D9Sm/2QY+BXvnWvM7nuZ2uxDpauT43jxup7SxuG9q3iUt1KnafTzd+cYjtXBxfk8Q/GmBSCeaTo6wJhcZQH4ku51ofJrKTTeRsZI41UVGGsAxnpTk4xPfAFI/vi33j2wBa638XZl49//v3je7MLkPu80Nde64cmKWBFHDqNDWpP4wHdqgpq+7gYKmJSippb7DODyHW7X4gB/niyWbCnU2sWgBRnPjrxR8Xfnz5ASpsoEkmsL+Bjf8WKumWBBVAtSi4ecsymuqchudZww36W0N/w3lappxRThawhhvEDTVZjUCG+SEypFzc0p9vZhq/3epKMQbU5o50z+Qo/oDG42z2AkvupqEXVjlQJPRFdgcNu5XGzG8lSJp8yz53Bms1y3fMYzcKzc9dS9n8a1jblyMjfH0sAhxgT7CwzWuCaxgR96miyRk/AnPxHTCnWvSgxeCriWmgM8s+1njBpdyHcbB6ctyivSWNmZwcpCRFZ5MYciNWOa16Z9pIrI7byO9GRlgZGWENEN4CAh3R2d8KAAA=";
    public static final String PROPERTY$ACCOUNTS_REPORTS_PERIOD_SEARCH_PANEL0 = "$AccountsReportsPeriodSearchPanel0";
    public static final String PROPERTY$JCOMBO_BOX0 = "$JComboBox0";
    public static final String PROPERTY$LIST_SELECTION_MODEL0 = "$ListSelectionModel0";
    private static final Log log = LogFactory.getLog(org.chorem.lima.ui.accountsreports.AccountsReportsView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel accountSelectorLabel;
    protected org.jdesktop.swingx.JXTable accountsReportsTable;
    protected javax.swing.JLabel amountCreditLabel;
    protected javax.swing.JLabel amountDebitLabel;
    protected javax.swing.JLabel amountSoldeLabel;
    protected javax.swing.JButton back;
    protected org.chorem.lima.ui.accountsreports.AccountsReportsViewHandler handler;
    protected org.chorem.lima.ui.accountsreports.AccountsReportsTableModel modelAccountsReportsTable;
    protected javax.swing.JButton next;
    protected javax.swing.JComboBox periodComboBox;
    protected java.lang.Boolean selectedRow;
    protected javax.swing.JLabel soldeLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AccountsReportsView $Table0 = this;
    private jaxx.runtime.swing.Table $Table1;
    private org.chorem.lima.ui.accountsreports.AccountsReportsPeriodSearchPanel $AccountsReportsPeriodSearchPanel0;
    private javax.swing.JComboBox $JComboBox0;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.ListSelectionModel $ListSelectionModel0;
    private jaxx.runtime.swing.Table $Table2;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    AccountsReportsPeriodSearchPanel periodSearchPanel;
    AccountComboBox comboBox;
    
        
        void $afterCompleteSetup() {
        }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AccountsReportsView() {
        $initialize();
    }

    public AccountsReportsView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__back(java.awt.event.ActionEvent event) {
        comboBox.back();
    }

    public void doActionPerformed__on__next(java.awt.event.ActionEvent event) {
        comboBox.next();
    }

    public void doActionPerformed__on__periodComboBox(java.awt.event.ActionEvent event) {
        periodSearchPanel.refresh(ComboBoxDatesEnum.valueOfDescription((String) periodComboBox.getSelectedItem()));                  validate(); repaint();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JLabel getAccountSelectorLabel() {
        return accountSelectorLabel;
    }

    public org.jdesktop.swingx.JXTable getAccountsReportsTable() {
        return accountsReportsTable;
    }

    public javax.swing.JLabel getAmountCreditLabel() {
        return amountCreditLabel;
    }

    public javax.swing.JLabel getAmountDebitLabel() {
        return amountDebitLabel;
    }

    public javax.swing.JLabel getAmountSoldeLabel() {
        return amountSoldeLabel;
    }

    public javax.swing.JButton getBack() {
        return back;
    }

    public org.chorem.lima.ui.accountsreports.AccountsReportsViewHandler getHandler() {
        return handler;
    }

    public org.chorem.lima.ui.accountsreports.AccountsReportsTableModel getModelAccountsReportsTable() {
        return modelAccountsReportsTable;
    }

    public javax.swing.JButton getNext() {
        return next;
    }

    public javax.swing.JComboBox getPeriodComboBox() {
        return periodComboBox;
    }

    public java.lang.Boolean getSelectedRow() {
        return selectedRow;
    }

    public javax.swing.JLabel getSoldeLabel() {
        return soldeLabel;
    }

    public java.lang.Boolean isSelectedRow() {
        return selectedRow !=null && selectedRow;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$AccountsReportsPeriodSearchPanel0(org.chorem.lima.ui.accountsreports.AccountsReportsPeriodSearchPanel newValue) {
        org.chorem.lima.ui.accountsreports.AccountsReportsPeriodSearchPanel oldValue = this.$AccountsReportsPeriodSearchPanel0;
        this.$AccountsReportsPeriodSearchPanel0 = newValue;
        firePropertyChange(PROPERTY$ACCOUNTS_REPORTS_PERIOD_SEARCH_PANEL0, oldValue, newValue);
    }

    public void set$JComboBox0(javax.swing.JComboBox newValue) {
        javax.swing.JComboBox oldValue = this.$JComboBox0;
        this.$JComboBox0 = newValue;
        firePropertyChange(PROPERTY$JCOMBO_BOX0, oldValue, newValue);
    }

    public void set$ListSelectionModel0(javax.swing.ListSelectionModel newValue) {
        javax.swing.ListSelectionModel oldValue = this.$ListSelectionModel0;
        this.$ListSelectionModel0 = newValue;
        firePropertyChange(PROPERTY$LIST_SELECTION_MODEL0, oldValue, newValue);
    }

    public void setHandler(org.chorem.lima.ui.accountsreports.AccountsReportsViewHandler newValue) {
        org.chorem.lima.ui.accountsreports.AccountsReportsViewHandler oldValue = this.handler;
        this.handler = newValue;
        firePropertyChange(PROPERTY_HANDLER, oldValue, newValue);
    }

    public void setPeriodComboBox(javax.swing.JComboBox newValue) {
        javax.swing.JComboBox oldValue = this.periodComboBox;
        this.periodComboBox = newValue;
        firePropertyChange(PROPERTY_PERIOD_COMBO_BOX, oldValue, newValue);
    }

    public void setSelectedRow(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.selectedRow;
        this.selectedRow = newValue;
        firePropertyChange(PROPERTY_SELECTED_ROW, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected org.chorem.lima.ui.accountsreports.AccountsReportsPeriodSearchPanel get$AccountsReportsPeriodSearchPanel0() {
        return $AccountsReportsPeriodSearchPanel0;
    }

    protected javax.swing.JComboBox get$JComboBox0() {
        return $JComboBox0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    protected jaxx.runtime.swing.Table get$Table2() {
        return $Table2;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAccountSelectorLabel() {
        $objectMap.put("accountSelectorLabel", accountSelectorLabel = new javax.swing.JLabel());
        
        accountSelectorLabel.setName("accountSelectorLabel");
        accountSelectorLabel.setText(_("lima.common.account"));
    }

    protected void createAccountsReportsTable() {
        $objectMap.put("accountsReportsTable", accountsReportsTable = new org.jdesktop.swingx.JXTable());
        
        accountsReportsTable.setName("accountsReportsTable");
        accountsReportsTable.setColumnControlVisible(true);
        accountsReportsTable.setRowHeight(24);
    }

    protected void createAmountCreditLabel() {
        $objectMap.put("amountCreditLabel", amountCreditLabel = new javax.swing.JLabel());
        
        amountCreditLabel.setName("amountCreditLabel");
    }

    protected void createAmountDebitLabel() {
        $objectMap.put("amountDebitLabel", amountDebitLabel = new javax.swing.JLabel());
        
        amountDebitLabel.setName("amountDebitLabel");
    }

    protected void createAmountSoldeLabel() {
        $objectMap.put("amountSoldeLabel", amountSoldeLabel = new javax.swing.JLabel());
        
        amountSoldeLabel.setName("amountSoldeLabel");
    }

    protected void createBack() {
        $objectMap.put("back", back = new javax.swing.JButton());
        
        back.setName("back");
        back.setText(_("lima.common.buttonback"));
        back.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__back"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new AccountsReportsViewHandler(this));
    }

    protected void createModelAccountsReportsTable() {
        $objectMap.put("modelAccountsReportsTable", modelAccountsReportsTable = new org.chorem.lima.ui.accountsreports.AccountsReportsTableModel());
    }

    protected void createNext() {
        $objectMap.put("next", next = new javax.swing.JButton());
        
        next.setName("next");
        next.setText(_("lima.common.buttonnext"));
        next.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__next"));
    }

    protected void createPeriodComboBox() {
        $objectMap.put("periodComboBox", periodComboBox = new JComboBox(ComboBoxDatesEnum.descriptions()));
        
        periodComboBox.setName("periodComboBox");
        periodComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__periodComboBox"));
    }

    protected void createSelectedRow() {
        $objectMap.put("selectedRow", selectedRow = false);
    }

    protected void createSoldeLabel() {
        $objectMap.put("soldeLabel", soldeLabel = new javax.swing.JLabel());
        
        soldeLabel.setName("soldeLabel");
        soldeLabel.setText(_("lima.common.solde"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $Table0
        add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(accountSelectorLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JComboBox0, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(back, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(next, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 6, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($Table2, new GridBagConstraints(0, 2, 7, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add(periodComboBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($AccountsReportsPeriodSearchPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(accountsReportsTable);
        // inline complete setup of $Table2
        $Table2.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(amountDebitLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel1, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(amountCreditLabel, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(soldeLabel, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(amountSoldeLabel, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 3 property setters
        accountsReportsTable.setHighlighters(org.jdesktop.swingx.decorator.HighlighterFactory.createSimpleStriping(new java.awt.Color(222,222,222)));
        accountsReportsTable.setModel(getModelAccountsReportsTable());
        accountsReportsTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$Table0", this);
        createHandler();
        createSelectedRow();
        createModelAccountsReportsTable();
        periodSearchPanel = new AccountsReportsPeriodSearchPanel(handler);
        comboBox = new AccountComboBox(handler);
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        
        $Table1.setName("$Table1");
        createPeriodComboBox();
        // inline creation of $AccountsReportsPeriodSearchPanel0
        $objectMap.put("$AccountsReportsPeriodSearchPanel0", $AccountsReportsPeriodSearchPanel0 = periodSearchPanel);
        
        $AccountsReportsPeriodSearchPanel0.setName("$AccountsReportsPeriodSearchPanel0");
        createAccountSelectorLabel();
        // inline creation of $JComboBox0
        $objectMap.put("$JComboBox0", $JComboBox0 = comboBox);
        
        $JComboBox0.setName("$JComboBox0");
        createBack();
        createNext();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createAccountsReportsTable();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = getAccountsReportsTable().getSelectionModel());
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new jaxx.runtime.swing.Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("lima.common.amountdebit"));
        createAmountDebitLabel();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("lima.common.amountcredit"));
        createAmountCreditLabel();
        createSoldeLabel();
        createAmountSoldeLabel();
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

}