/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.combobox;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.AccountServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.entity.Account;
import org.chorem.lima.service.LimaServiceFactory;

public class SubAccountComboBoxModel
extends AbstractListModel
implements ComboBoxModel,
ServiceListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SubAccountComboBoxModel.class);
    protected Object selectedAccount;
    protected List<Account> datasCache;
    protected AccountServiceMonitorable accountService = LimaServiceFactory.getInstance().getService(AccountServiceMonitorable.class);

    public SubAccountComboBoxModel() {
        this.accountService.addListener((ServiceListener)this);
        LimaServiceFactory.getInstance().getService(ImportServiceMonitorable.class).addListener((ServiceListener)this);
        this.datasCache = this.getDataList();
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedAccount;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedAccount = anItem;
        this.fireContentsChanged(this, -1, -1);
    }

    @Override
    public Object getElementAt(int index) {
        return this.datasCache.get(index);
    }

    @Override
    public int getSize() {
        return this.datasCache.size();
    }

    public List<Account> getDataList() {
        ArrayList<Account> result;
        block2: {
            result = new ArrayList();
            try {
                result = this.accountService.getAllSubAccounts();
            }
            catch (LimaException eee) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"Can't get list subaccounts", (Throwable)eee);
            }
        }
        return result;
    }

    public void refresh() {
        this.datasCache = this.getDataList();
        this.fireContentsChanged(this, 0, this.datasCache.size());
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if (serviceName.contains("Account") || methodeName.contains("importAll")) {
            this.refresh();
        }
    }
}

