/* *##% Lima Swing
 * Copyright (C) 2008 - 2010 CodeLutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * ##%*/

package org.chorem.lima.ui.financialtransactionsearch;

import javax.swing.JPanel;
import org.chorem.lima.enums.ComboBoxLetterEnum;

public class LetterSearchPanel extends JPanel {
	
	protected FinancialTransactionSearchViewHandler handler;
	
	public LetterSearchPanel(FinancialTransactionSearchViewHandler handler) {
		this.handler = handler;
	}
	
	static final long serialVersionUID = 1L;

	public void refresh(ComboBoxLetterEnum comboBoxEnum){
		
		switch (comboBoxEnum) {
		case ALL:
			handler.setLetter(null);
			handler.refresh();
			this.removeAll();
			break;
			
		case SELECT_ONE:
			LetterSearchComboBox comboBox = new LetterSearchComboBox(handler);
			this.removeAll();
			this.add(comboBox);
			break;
			
		}
		
	}
	
}
