/* *##% Lima Swing
 * Copyright (C) 2008 - 2010 CodeLutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * ##%*/

package org.chorem.lima.ui.combobox;

import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.FiscalPeriodServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.financialperiod.FinancialPeriodTableModel;

public class FiscalPeriodComboBoxModel extends AbstractListModel implements ComboBoxModel, ServiceListener{

	private static final long serialVersionUID = 1L;

	private static final Log log = LogFactory.getLog(FinancialPeriodTableModel.class);

    protected Object selectedFiscalPeriod;
    
    protected FiscalPeriodServiceMonitorable fiscalPeriodService;
    
    protected List<FiscalPeriod> datasCache;

    
    public FiscalPeriodComboBoxModel(){
        fiscalPeriodService =
        	LimaServiceFactory.getInstance().getService(
        			FiscalPeriodServiceMonitorable.class);
        fiscalPeriodService.addListener(this);
    	LimaServiceFactory.getInstance().getService(
    			ImportServiceMonitorable.class).addListener(this);
        datasCache = getDataList();
    }
	
    @Override
    public int getSize() {
        return datasCache.size();
    }

    @Override
    public Object getElementAt(int index) {
        return datasCache.get(index);
    }


    @Override
    public void setSelectedItem(Object anItem) {
        selectedFiscalPeriod = anItem;
    }

    @Override
    public Object getSelectedItem() {
        return selectedFiscalPeriod;
    }
    
    public List<FiscalPeriod> getDataList(){
        List<FiscalPeriod> result = null;
        try {
            result = fiscalPeriodService.getAllUnblockedFiscalPeriods();
        }
        catch (LimaException eee) {
            if (log.isDebugEnabled()){
                log.debug("Can't get list accounts", eee);
            }
        }
        return result;
        
    }
    
    public void refresh(){
    	datasCache = getDataList();
    	fireContentsChanged(this, 0, datasCache.size());
    }
    
	@Override
	public void notifyMethod(String serviceName, String methodeName) {
		if (serviceName.contains("FiscalPeriod") || methodeName.contains("importAll")){
			refresh();
		}	
	}
}
