/* *##%
 Copyright (C) 2009 Callao
 *##%*/
package org.chorem.callao.entity;

import java.util.List;


import java.util.Arrays;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;

/**
 * Implantation DAO pour l'entité TimeSpan.
 * Cette classe contient une implantation de TopiaDAO a laquel elle peut
 * deleguer des traitements
 * 
 */
public abstract class TimeSpanDAOAbstract<E extends TimeSpan> extends org.nuiton.topia.persistence.TopiaDAOImpl<E> implements org.nuiton.topia.persistence.TopiaDAO<E> {    

    public Class<E> getEntityClass() {
        return (Class<E>)TimeSpan.class;
    }

    public void delete(E entity) throws TopiaException {

                {
                List<org.chorem.callao.entity.Transaction> list = getContext()
                            .getDAO(org.chorem.callao.entity.Transaction.class)
                            .findAllByProperties("timeSpan", entity);
                    for (org.chorem.callao.entity.Transaction item : list) {
                        item.setTimeSpan(null);

                    }
                }
                
        super.delete(entity);
    }    
     
    /**
     * Recherche sur l'attribut beginTimeSpan
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * beginTimeSpan le paramètre
     * @param v la valeur que doit avoir beginTimeSpan
     * @return un element ou null
     */
    public E findByBeginTimeSpan(java.util.Date v) throws TopiaException {
        E result = findByProperty("beginTimeSpan", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * beginTimeSpan le paramètre
     * @param v la valeur que doit avoir beginTimeSpan
     * @return une liste
     */
    public List<E> findAllByBeginTimeSpan(java.util.Date v) throws TopiaException {
        List<E> result = findAllByProperty("beginTimeSpan", v);
        return result;
    }
    /**
     * Recherche sur l'attribut endTimeSpan
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * endTimeSpan le paramètre
     * @param v la valeur que doit avoir endTimeSpan
     * @return un element ou null
     */
    public E findByEndTimeSpan(java.util.Date v) throws TopiaException {
        E result = findByProperty("endTimeSpan", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * endTimeSpan le paramètre
     * @param v la valeur que doit avoir endTimeSpan
     * @return une liste
     */
    public List<E> findAllByEndTimeSpan(java.util.Date v) throws TopiaException {
        List<E> result = findAllByProperty("endTimeSpan", v);
        return result;
    }
    /**
     * Recherche sur l'attribut locked
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * locked le paramètre
     * @param v la valeur que doit avoir locked
     * @return un element ou null
     */
    public E findByLocked(boolean v) throws TopiaException {
        E result = findByProperty("locked", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * locked le paramètre
     * @param v la valeur que doit avoir locked
     * @return une liste
     */
    public List<E> findAllByLocked(boolean v) throws TopiaException {
        List<E> result = findAllByProperty("locked", v);
        return result;
    }
    /**
     * Recherche sur l'attribut period
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * period le paramètre
     * @param v la valeur que doit avoir period
     * @return un element ou null
     */
    public E findByPeriod(org.chorem.callao.entity.Period v) throws TopiaException {
        E result = findByProperty("period", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * period le paramètre
     * @param v la valeur que doit avoir period
     * @return une liste
     */
    public List<E> findAllByPeriod(org.chorem.callao.entity.Period v) throws TopiaException {
        List<E> result = findAllByProperty("period", v);
        return result;
    }
    /**
     * Recherche sur l'attribut transaction
     */
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * transaction contient le paramètre
     * @param v la valeur que doit contenir transaction
     * @return un element ou null
     */
    public E findContainsTransaction(org.chorem.callao.entity.Transaction ... v) throws TopiaException {
        E result = findContainsProperties("transaction", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * transaction contient le paramètre
     * @param v la valeur que doit contenir transaction
     * @return une liste
     */
    public List<E> findAllContainsTransaction(org.chorem.callao.entity.Transaction ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("transaction", Arrays.asList(v));
        return results;
    }

} // TimeSpanDAOAbstract
