/* *##%
 Copyright (C) 2009 Callao
 *##%*/
package org.chorem.callao.entity;

import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

@SearchFields (
  boolFields={"locked"},
  dateFields={"beginTimeSpan","endTimeSpan"}
)        
public interface TimeSpan extends TopiaEntity {

    public static final String BEGIN_TIME_SPAN = "beginTimeSpan";

    public static final String END_TIME_SPAN = "endTimeSpan";

    public static final String LOCKED = "locked";

    public static final String PERIOD = "period";

    public static final String TRANSACTION = "transaction";

    /**
     * @param beginTimeSpan La valeur de l'attribut beginTimeSpan à positionner.
     */
    public void setBeginTimeSpan(java.util.Date beginTimeSpan);

    /**
     * @return La valeur de l'attribut beginTimeSpan.
     */
    public java.util.Date getBeginTimeSpan();

    /**
     * @param endTimeSpan La valeur de l'attribut endTimeSpan à positionner.
     */
    public void setEndTimeSpan(java.util.Date endTimeSpan);

    /**
     * @return La valeur de l'attribut endTimeSpan.
     */
    public java.util.Date getEndTimeSpan();

    /**
     * @param locked La valeur de l'attribut locked à positionner.
     */
    public void setLocked(boolean locked);

    /**
     * @return La valeur de l'attribut locked.
     */
    public boolean getLocked();

    /**
     * @param period La valeur de l'attribut period à positionner.
     */
    public void setPeriod(org.chorem.callao.entity.Period period);

    /**
     * @return La valeur de l'attribut period.
     */
    public org.chorem.callao.entity.Period getPeriod();

    /**
     * @param transaction L'instance de transaction à ajouter.
     */
    public void addTransaction(org.chorem.callao.entity.Transaction transaction);

    /**
     * @param transaction Les instances de transaction à ajouter.
     */
    public void addAllTransaction(java.util.Collection<org.chorem.callao.entity.Transaction> transaction);

    /**
     * @param transaction La Collection de transaction à positionner.
     */
    public void setTransaction(java.util.Collection<org.chorem.callao.entity.Transaction> transaction);

    /**
     * @param transaction L'instance de transaction à retirer.
     */
    public void removeTransaction(org.chorem.callao.entity.Transaction transaction);

    /**
     * Vide la Collection de transaction.
     */
    public void clearTransaction();

    /**
     * @return La Liste de transaction.
     */
    public java.util.Collection<org.chorem.callao.entity.Transaction> getTransaction();


    /**
     * Recupère l'attribut transaction à partir de son topiaId.
     *
     * @param topiaId le topia id de l'entité recherchée
     *
     * @return l'attribut recherché, ou <code>null</code> s'il n'existe pas.
     */
    public org.chorem.callao.entity.Transaction getTransactionByTopiaId(String topiaId);
 
    /**
     * @return Le nombre d'éléments de la collection transaction.
     */
    public int sizeTransaction();

    /**
     * @return <code>true</code> si la collection transaction est vide.
     */
    public boolean isTransactionEmpty();

} //TimeSpan
