/* *##%
 Copyright (C) 2009 Callao
 *##%*/
package org.chorem.callao.entity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

/**
 * Implantation POJO pour l'entité {@link Period}.
 */
public abstract class PeriodAbstract extends TopiaEntityAbstract implements Period {

    private Date beginPeriod;

    private Date endPeriod;

    private boolean locked;

    public Collection<TimeSpan> timeSpan;

    /**
     * Constructeur de PeriodAbstract par défaut.
     */
    public PeriodAbstract() {
    }

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Period.class).update(this);
    }

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Period.class).delete(this);
    }

    /**
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
     * avec leur nom, type et valeur.
     *
     * @param visitor le visiteur de l'entite.
     *
     * @throws TopiaException if any pb while visit 
     */
    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "beginPeriod", Date.class, beginPeriod);
        visitor.visit(this, "endPeriod", Date.class, endPeriod);
        visitor.visit(this, "locked", boolean.class, locked);
        visitor.visit(this, "timeSpan", Collection.class, TimeSpan.class, timeSpan);
        visitor.end(this);
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        if (getTimeSpan() != null) {
              tmp.addAll(getTimeSpan());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) { 
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        
        return result;
    }

    /* (non-Javadoc)
     * @see Period#setBeginPeriod(Date)
     */
    @Override
    public void setBeginPeriod(Date value) {
        Date _oldValue = this.beginPeriod;
        fireOnPreWrite("beginPeriod", _oldValue, value);
        this.beginPeriod = value;
        fireOnPostWrite("beginPeriod", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Period#getBeginPeriod()
     */
    @Override
    public Date getBeginPeriod() {
        fireOnPreRead("beginPeriod", beginPeriod);
        Date result = this.beginPeriod;
        fireOnPostRead("beginPeriod", beginPeriod);
        return result;
    }

    /* (non-Javadoc)
     * @see Period#setEndPeriod(Date)
     */
    @Override
    public void setEndPeriod(Date value) {
        Date _oldValue = this.endPeriod;
        fireOnPreWrite("endPeriod", _oldValue, value);
        this.endPeriod = value;
        fireOnPostWrite("endPeriod", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Period#getEndPeriod()
     */
    @Override
    public Date getEndPeriod() {
        fireOnPreRead("endPeriod", endPeriod);
        Date result = this.endPeriod;
        fireOnPostRead("endPeriod", endPeriod);
        return result;
    }

    /* (non-Javadoc)
     * @see Period#setLocked(boolean)
     */
    @Override
    public void setLocked(boolean value) {
        boolean _oldValue = this.locked;
        fireOnPreWrite("locked", _oldValue, value);
        this.locked = value;
        fireOnPostWrite("locked", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Period#getLocked()
     */
    @Override
    public boolean getLocked() {
        fireOnPreRead("locked", locked);
        boolean result = this.locked;
        fireOnPostRead("locked", locked);
        return result;
    }

    /* (non-Javadoc)
     * @see Period#addTimeSpan(TimeSpan)
     */
    @Override
    public void addTimeSpan(TimeSpan timeSpan) {
        fireOnPreWrite("timeSpan", null, timeSpan);
        if (this.timeSpan == null) {
            this.timeSpan = new ArrayList<TimeSpan>();
        }
        timeSpan.setPeriod(this);
        this.timeSpan.add(timeSpan);
        fireOnPostWrite("timeSpan", this.timeSpan.size(), null, timeSpan);
    }

    /* (non-Javadoc)
     * @see Period#addAllTimeSpan(Collection<TimeSpan>)
     */
    @Override
    public void addAllTimeSpan(Collection<TimeSpan> values) {
        if (values == null) {
            return;
        }
        for (TimeSpan item : values) {
            addTimeSpan(item);
        }
    }

    /* (non-Javadoc)
     * @see Period#getTimeSpanByTopiaId(String)
     */
    @Override
    public TimeSpan getTimeSpanByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(timeSpan, topiaId);
    }
 
    /* (non-Javadoc)
     * @see Period#setTimeSpan(Collection<TimeSpan>)
     */
    @Override
    public void setTimeSpan(Collection<TimeSpan> values) {
        Collection<TimeSpan> _oldValue = timeSpan;
        fireOnPreWrite("timeSpan", _oldValue, values);
        timeSpan = values;
        fireOnPostWrite("timeSpan", _oldValue, values);
    }

    /* (non-Javadoc)
     * @see Period#removeTimeSpan(TimeSpan)
     */
    @Override
    public void removeTimeSpan(TimeSpan value) {
        fireOnPreWrite("timeSpan", value, null);
        if ((this.timeSpan == null) || (!this.timeSpan.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setPeriod(null);
        fireOnPostWrite("timeSpan", this.timeSpan.size()+1, value, null);
    }

    /* (non-Javadoc)
     * @see Period#clearTimeSpan()
     */
    @Override
    public void clearTimeSpan() {
        if (this.timeSpan == null) {
            return;
        }
        for (TimeSpan item : this.timeSpan) {
            item.setPeriod(null);
        }
        Collection<TimeSpan> _oldValue = new ArrayList<TimeSpan>(this.timeSpan);
        fireOnPreWrite("timeSpan", _oldValue, this.timeSpan);
        this.timeSpan.clear();
        fireOnPostWrite("timeSpan", _oldValue, this.timeSpan);
    }

    /* (non-Javadoc)
     * @see Period#getTimeSpan()
     */
    @Override
    public Collection<TimeSpan> getTimeSpan() {
        return timeSpan;
    }

    /* (non-Javadoc)
     * @see Period#sizeTimeSpan()
     */
    @Override
    public int sizeTimeSpan() {
        if (timeSpan == null) {
            return 0;
        }
        return timeSpan.size();
    }

    /* (non-Javadoc)
     * @see Period#isTimeSpanEmpty()
     */
    @Override
    public boolean isTimeSpanEmpty() {
        int size = sizeTimeSpan();
        return size == 0;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("beginPeriod", this.beginPeriod).
            append("endPeriod", this.endPeriod).
            append("locked", this.locked).
         toString();
        return result;
    }
        
} //PeriodAbstract
