/* *##%
 Copyright (C) 2009 Callao
 *##%*/
package org.chorem.callao.entity;

import java.util.List;


import java.util.Arrays;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;

/**
 * Implantation DAO pour l'entité Account.
 * Cette classe contient une implantation de TopiaDAO a laquel elle peut
 * deleguer des traitements
 * 
 */
public abstract class AccountDAOAbstract<E extends Account> extends org.nuiton.topia.persistence.TopiaDAOImpl<E> implements org.nuiton.topia.persistence.TopiaDAO<E> {    

    public Class<E> getEntityClass() {
        return (Class<E>)Account.class;
    }

    public void delete(E entity) throws TopiaException {

                {
                List<org.chorem.callao.entity.Entry> list = getContext()
                            .getDAO(org.chorem.callao.entity.Entry.class)
                            .findAllByProperties("account", entity);
                    for (org.chorem.callao.entity.Entry item : list) {
                        item.setAccount(null);

                    }
                }
        
                {
                List<org.chorem.callao.entity.Account> list = getContext()
                            .getDAO(org.chorem.callao.entity.Account.class)
                            .findAllByProperties("masterAccount", entity);
                    for (org.chorem.callao.entity.Account item : list) {
                        item.setMasterAccount(null);

            			item.delete();

                    }
                }
                
        super.delete(entity);
    }    
     
    /**
     * Recherche sur l'attribut label
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * label le paramètre
     * @param v la valeur que doit avoir label
     * @return un element ou null
     */
    public E findByLabel(java.lang.String v) throws TopiaException {
        E result = findByProperty("label", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * label le paramètre
     * @param v la valeur que doit avoir label
     * @return une liste
     */
    public List<E> findAllByLabel(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("label", v);
        return result;
    }
    /**
     * Recherche sur l'attribut accountNumber
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * accountNumber le paramètre
     * @param v la valeur que doit avoir accountNumber
     * @return un element ou null
     */
    public E findByAccountNumber(java.lang.String v) throws TopiaException {
        E result = findByProperty("accountNumber", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * accountNumber le paramètre
     * @param v la valeur que doit avoir accountNumber
     * @return une liste
     */
    public List<E> findAllByAccountNumber(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("accountNumber", v);
        return result;
    }
    /**
     * Recherche sur l'attribut type
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * type le paramètre
     * @param v la valeur que doit avoir type
     * @return un element ou null
     */
    public E findByType(java.lang.String v) throws TopiaException {
        E result = findByProperty("type", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * type le paramètre
     * @param v la valeur que doit avoir type
     * @return une liste
     */
    public List<E> findAllByType(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("type", v);
        return result;
    }
    /**
     * Recherche sur l'attribut entry
     */
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * entry contient le paramètre
     * @param v la valeur que doit contenir entry
     * @return un element ou null
     */
    public E findContainsEntry(org.chorem.callao.entity.Entry ... v) throws TopiaException {
        E result = findContainsProperties("entry", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * entry contient le paramètre
     * @param v la valeur que doit contenir entry
     * @return une liste
     */
    public List<E> findAllContainsEntry(org.chorem.callao.entity.Entry ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("entry", Arrays.asList(v));
        return results;
    }
    /**
     * Recherche sur l'attribut masterAccount
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * masterAccount le paramètre
     * @param v la valeur que doit avoir masterAccount
     * @return un element ou null
     */
    public E findByMasterAccount(org.chorem.callao.entity.Account v) throws TopiaException {
        E result = findByProperty("masterAccount", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * masterAccount le paramètre
     * @param v la valeur que doit avoir masterAccount
     * @return une liste
     */
    public List<E> findAllByMasterAccount(org.chorem.callao.entity.Account v) throws TopiaException {
        List<E> result = findAllByProperty("masterAccount", v);
        return result;
    }
    /**
     * Recherche sur l'attribut subAccount
     */
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * subAccount contient le paramètre
     * @param v la valeur que doit contenir subAccount
     * @return un element ou null
     */
    public E findContainsSubAccount(org.chorem.callao.entity.Account ... v) throws TopiaException {
        E result = findContainsProperties("subAccount", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * subAccount contient le paramètre
     * @param v la valeur que doit contenir subAccount
     * @return une liste
     */
    public List<E> findAllContainsSubAccount(org.chorem.callao.entity.Account ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("subAccount", Arrays.asList(v));
        return results;
    }

} // AccountDAOAbstract
