/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.actions;

import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceConfig;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.DataSourceFactory;
import fr.ird.observe.db.impl.H2DataSourceConfig;
import fr.ird.observe.db.impl.PGDataSourceConfig;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.ObserveMainUIHandler;
import fr.ird.observe.ui.actions.AbstractObserveAction;
import java.awt.event.ActionEvent;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ReloadStorageAction
extends AbstractObserveAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ReloadStorageAction.class);
    private final ObserveMainUI ui;

    public ReloadStorageAction(ObserveMainUI ui) {
        super(I18n.t((String)"observe.action.reload.storage", (Object[])new Object[0]), SwingUtil.getUIManagerActionIcon((String)"db-reload"));
        this.ui = ui;
        this.putValue("ShortDescription", I18n.t((String)"observe.action.reload.storage.tip", (Object[])new Object[0]));
        this.putValue("MnemonicKey", 82);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean canContinue = ObserveContext.get().closeSelectedContentUI(this.ui);
        DataSource storage = ObserveMainUIHandler.getStorage();
        if (canContinue && storage != null) {
            this.ui.setBusy(false);
            String[] ids = this.ui.getTreeHelper().getSelectedIds();
            try {
                DataSourceConfig config;
                block12: {
                    config = storage.getConfig().clone();
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(">>> close main storage " + storage));
                        }
                        storage.doClose(false);
                    }
                    catch (DataSourceException e) {
                        ErrorDialogUI.showError((Exception)((Object)e));
                        if (!log.isErrorEnabled()) break block12;
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                ObserveConfig appConfig = ObserveContext.get().getConfig();
                if (config instanceof H2DataSourceConfig) {
                    H2DataSourceConfig h2Config = (H2DataSourceConfig)config;
                    h2Config.setCanMigrate(appConfig.isCanMigrateH2());
                    h2Config.detectPolicy();
                }
                if (config instanceof PGDataSourceConfig) {
                    PGDataSourceConfig pgConfig = (PGDataSourceConfig)config;
                    pgConfig.setCanMigrate(appConfig.isCanMigrateObstuna());
                }
                try {
                    storage = DataSourceFactory.newService((DataSourceConfig)config, storage.getClass());
                    ObserveContext.get().setNodesToReselect(ids);
                    ObserveContext.get().prepareMainStorage(storage);
                    storage.doOpen();
                }
                catch (Exception e) {
                    ErrorDialogUI.showError((Exception)e);
                    if (log.isErrorEnabled()) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            finally {
                this.ui.setBusy(false);
            }
        }
    }
}

