/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.actions;

import fr.ird.observe.ui.ObserveMainUI;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.h2.tools.Server;
import org.nuiton.i18n.I18n;

public class StopH2WebServerAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(StopH2WebServerAction.class);
    private final ObserveMainUI ui;

    public StopH2WebServerAction(ObserveMainUI ui) {
        super(I18n.t((String)"observe.action.stop.h2.web.server", (Object[])new Object[0]), SwingUtil.getUIManagerActionIcon((String)"db-stop-server"));
        this.ui = ui;
        this.putValue("ShortDescription", I18n.t((String)"observe.action.stop.h2.web.server.tip", (Object[])new Object[0]));
        this.putValue("MnemonicKey", 83);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.ui.isH2WebServer().booleanValue()) {
            Server server;
            if (log.isInfoEnabled()) {
                log.info((Object)"Will stop web server mode...");
            }
            if ((server = this.ui.getContextValue(Server.class, "webServer")) != null) {
                server.stop();
            }
            this.ui.setH2WebServer(false);
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Can not stop h2 web server... (no web server found)");
        }
    }
}

