/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table;

import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.table.ContentTableMeta;
import fr.ird.observe.ui.content.table.ContentTableUIHandler;
import fr.ird.observe.ui.content.table.ContentTableUIModel;
import fr.ird.observe.ui.content.table.ObserveContentTableUI;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.EntityListUpdator;
import org.nuiton.topia.persistence.util.Loador;

public class ContentTableModel<P extends TopiaEntity, B extends TopiaEntity>
extends AbstractTableModel {
    public static final String SELECTED_ROW_PROPERTY = "selectedRow";
    public static final String MODIFIED_PROPERTY = "modified";
    public static final String EDITABLE_PROPERTY = "editable";
    public static final String CREATE_PROPERTY = "create";
    public static final String EMPTY_PROPERTY = "empty";
    private static final long serialVersionUID = 1L;
    protected static Log log = LogFactory.getLog(ContentTableModel.class);
    protected final List<ContentTableMeta<B>> metas;
    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    protected List<B> data = new ArrayList<B>();
    protected boolean modified;
    protected boolean editable;
    protected boolean create;
    protected boolean valueAdjusting;
    protected int selectedRow = -1;
    protected String deleteExtraMessage;
    private boolean init;
    private ObserveContentTableUI<P, B> context;

    public ContentTableModel(ObserveContentTableUI<P, B> context, List<ContentTableMeta<B>> metas) {
        if (CollectionUtils.isEmpty(metas)) {
            throw new NullPointerException("meta parameter can not be null, nor empty");
        }
        this.context = context;
        this.metas = Collections.unmodifiableList(metas);
    }

    public static <D extends TopiaEntity> ContentTableMeta<D> newTableMeta(Class<D> childType, String property, boolean unmodiableWhenExisting) {
        return new ContentTableMeta<D>(childType, property, unmodiableWhenExisting);
    }

    public void attachModel() {
        this.setSelectedRow(-1);
        this.setCreate(false);
        this.setInit(true);
        this.updateEmpty();
        if (log.isDebugEnabled()) {
            log.debug((Object)("editable : " + this.isEditable()));
            log.debug((Object)("size : " + this.getRowCount()));
        }
        this.fireTableDataChanged();
    }

    public void dettachModel() {
        this.setModified(false);
        int size = this.getRowCount();
        this.setInit(false);
        if (size > 0) {
            this.fireTableRowsDeleted(0, size - 1);
            this.updateEmpty();
        }
        this.setSelectedRow(-1);
        this.setCreate(false);
    }

    public void addNewEntry() {
        this.ensureEditable();
        if (this.getSelectedRow() > -1 && !this.isCanQuitEditingRow()) {
            return;
        }
        int row = this.getRowCount();
        Object bean = null;
        try {
            bean = this.getModel().newTableEditBean();
        }
        catch (Exception e) {
            ErrorDialogUI.showError((Exception)e);
        }
        this.data.add(bean);
        this.updateBeanList(false);
        this.fireTableRowsInserted(row, row);
        this.updateEmpty();
        this.setCreate(true);
        this.changeSelectedRow(row);
    }

    protected ContentTableUIModel<P, B> getModel() {
        return this.getHandler().getModel();
    }

    public void doRemoveRow(int rowToDelete, boolean force) {
        B bean = this.getValueAt(rowToDelete);
        ContentTableMeta<B> meta = this.getColumnMeta(this.getColumnCount() - 1);
        if (force || UIHelper.confirmForEntityDelete(null, meta.klass, bean, this.deleteExtraMessage)) {
            this.removeRow(rowToDelete);
            this.changeSelectedRow(--rowToDelete);
            if (rowToDelete == -1 && !this.isEmpty()) {
                this.changeSelectedRow(0);
            }
        }
    }

    public boolean isCanQuitEditingRow() {
        if (this.selectedRow == -1) {
            return true;
        }
        if (!this.create && !this.getValidator().isChanged()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("editing row " + this.getSelectedRow() + " was modified, need confirmation"));
        }
        boolean canContinue = false;
        if (this.getValidator().isValid()) {
            int reponse = UIHelper.askUser(I18n.t((String)"observe.title.need.confirm", (Object[])new Object[0]), I18n.t((String)"observe.message.table.editBean.modified", (Object[])new Object[0]), 2, new Object[]{I18n.t((String)"observe.choice.save", (Object[])new Object[0]), I18n.t((String)"observe.choice.doNotSave", (Object[])new Object[0]), I18n.t((String)"observe.choice.cancel", (Object[])new Object[0])}, 0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("response : " + reponse));
            }
            switch (reponse) {
                case -1: 
                case 2: {
                    break;
                }
                case 0: {
                    this.updateRowFromEditBean();
                    canContinue = true;
                    break;
                }
                case 1: {
                    canContinue = true;
                    if (!this.create) break;
                    this.removeRow(this.getSelectedRow());
                }
            }
        } else {
            int reponse = UIHelper.askUser(I18n.t((String)"observe.title.need.confirm", (Object[])new Object[0]), I18n.t((String)"observe.message.table.editBean.modified.but.invalid", (Object[])new Object[0]), 0, new Object[]{I18n.t((String)"observe.choice.continue", (Object[])new Object[0]), I18n.t((String)"observe.choice.cancel", (Object[])new Object[0])}, 0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("response : " + reponse));
            }
            switch (reponse) {
                case 0: {
                    canContinue = true;
                    if (!this.create) break;
                    this.removeRow(this.getSelectedRow());
                }
            }
        }
        return canContinue;
    }

    public void changeSelectedRow(int row) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("row      : " + row));
            log.debug((Object)("editable : " + this.isEditable()));
            log.debug((Object)("size     : " + this.getRowCount()));
        }
        if (this.editable) {
            this.getValidator().setBean(null);
        }
        if (row == -1) {
            this.setSelectedRow(row);
            return;
        }
        this.ensureRowIndex(row);
        if (this.editable) {
            this.getValidator().setBean(this.getRowBean());
        }
        B beanToBind = this.getValueAt(row);
        this.getChildLoador().load(beanToBind, this.getRowBean(), true, new String[0]);
        this.setSelectedRow(row);
        if (this.editable) {
            this.getValidator().setChanged(false);
        }
    }

    public void updateRowFromEditBean() {
        this.ensureEditable();
        int editingRow = this.getSelectedRow();
        B bean = this.getValueAt(editingRow);
        this.getChildLoador().load(this.getRowBean(), bean, true, new String[0]);
        this.fireTableRowsUpdated(editingRow, editingRow);
        if (this.create) {
            this.setCreate(false);
        }
        this.getValidator().setChanged(false);
        this.setModified(true);
        this.getParentValidator().doValidate();
    }

    public void resetEditBean() {
        B bean = this.getValueAt(this.getSelectedRow());
        this.getChildLoador().load(bean, this.getRowBean(), true, new String[0]);
        this.getValidator().setChanged(false);
    }

    protected ContentTableUIHandler<P, B> getHandler() {
        ContentTableUIHandler<P, B> handler = this.context.getHandler();
        return handler;
    }

    protected Loador<B> getChildLoador() {
        ContentTableUIModel<P, B> model = this.getModel();
        return model.getChildLoador();
    }

    protected EntityListUpdator<P, B> getChildsUpdator() {
        ContentTableUIModel<P, B> model = this.getModel();
        return model.getChildsUpdator();
    }

    protected P getBean() {
        ContentTableUIModel<P, B> model = this.getModel();
        return model == null ? null : (P)model.getBean();
    }

    public B getRowBean() {
        ContentTableUIModel<P, B> model = this.getModel();
        return model == null ? null : (B)model.getTableEditBean();
    }

    public boolean isCreate() {
        return this.create;
    }

    public void setCreate(boolean create) {
        boolean old = this.create;
        this.create = create;
        this.firePropertyChange(CREATE_PROPERTY, old, create);
    }

    public int getSelectedRow() {
        return this.selectedRow;
    }

    public void setSelectedRow(int selectedRow) {
        int old = this.selectedRow;
        this.selectedRow = selectedRow;
        this.firePropertyChange(SELECTED_ROW_PROPERTY, old, selectedRow);
    }

    public String getDeleteExtraMessage() {
        return this.deleteExtraMessage;
    }

    public void setDeleteExtraMessage(String deleteExtraMessage) {
        this.deleteExtraMessage = deleteExtraMessage;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        boolean oldModified = this.modified;
        this.modified = modified;
        this.firePropertyChange(MODIFIED_PROPERTY, oldModified, modified);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        boolean oldModified = this.editable;
        this.editable = editable;
        this.firePropertyChange(EDITABLE_PROPERTY, oldModified, editable);
    }

    public boolean isValueAdjusting() {
        return this.valueAdjusting;
    }

    public boolean isEmpty() {
        return this.getRowCount() == 0;
    }

    public List<B> getData() {
        if (this.data == null) {
            if (this.init) {
                P bean = this.getBean();
                Collection childs = this.getChildsUpdator().getChilds(bean);
                this.data = childs == null || childs.isEmpty() ? new ArrayList<B>() : new ArrayList<B>(childs);
            } else {
                this.data = new ArrayList<B>();
            }
        }
        return this.data;
    }

    public int getColumn(String columnName) {
        int i = 0;
        for (ContentTableMeta<B> m : this.metas) {
            if (m.getName().equals(columnName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int getRowCount() {
        List<B> list = this.getData();
        return list == null ? 0 : list.size();
    }

    @Override
    public int getColumnCount() {
        return this.metas.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        this.ensureColumnIndex(columnIndex);
        return this.metas.get(columnIndex).getName();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        this.ensureColumnIndex(columnIndex);
        return this.metas.get(columnIndex).getType();
    }

    public ContentTableMeta<B> getColumnMeta(int columnIndex) {
        this.ensureColumnIndex(columnIndex);
        return this.metas.get(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int row, int column) {
        this.ensureColumnIndex(column);
        ContentTableMeta<B> meta = this.getColumnMeta(column);
        B bean = this.getValueAt(row);
        return bean == null ? null : this.getValueAt(bean, row, meta);
    }

    public B getValueAt(int row) {
        this.ensureRowIndex(row);
        List<B> list = this.getData();
        return (B)(list == null ? null : (TopiaEntity)list.get(row));
    }

    public void updateEmpty() {
        this.firePropertyChange(EMPTY_PROPERTY, null, this.isEmpty());
    }

    public <T> List<T> getColumnValues(int column) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (!this.isEmpty()) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                Object value = this.getValueAt(i, column);
                if (value == null) continue;
                result.add(value);
            }
        }
        return result;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected SwingValidator<B> getValidator() {
        return this.context == null ? null : this.context.getValidatorTable();
    }

    protected SwingValidator<P> getParentValidator() {
        return this.context == null ? null : this.context.getValidator();
    }

    protected void removeRow(int row) {
        this.ensureRowIndex(row);
        this.setSelectedRow(-1);
        this.getData().remove(row);
        this.updateBeanList(!this.create);
        if (log.isDebugEnabled()) {
            log.debug((Object)row);
        }
        if (!this.create) {
            this.setModified(true);
        }
        this.fireTableRowsDeleted(row, row);
        if (this.create) {
            this.setCreate(false);
        }
        this.updateEmpty();
    }

    protected Object getValueAt(B bean, int row, ContentTableMeta<B> meta) {
        return meta.getValue(this, bean, row);
    }

    protected boolean setValueAt(B bean, Object aValue, int row, ContentTableMeta<B> meta) {
        return meta.setValue(this, bean, aValue, row);
    }

    protected void ensureColumnIndex(int columnIndex) throws ArrayIndexOutOfBoundsException {
        if (columnIndex < 0 || columnIndex >= this.metas.size()) {
            throw new ArrayIndexOutOfBoundsException("column index should be in [0," + this.metas.size() + "], but was " + columnIndex);
        }
    }

    protected void ensureRowIndex(int rowIndex) throws ArrayIndexOutOfBoundsException {
        int size = this.getRowCount();
        if (rowIndex < 0 || rowIndex >= size) {
            throw new ArrayIndexOutOfBoundsException("row index should be in [0," + (this.getRowCount() - 1) + "], but was " + rowIndex);
        }
    }

    protected void ensureEditable() throws IllegalStateException {
        if (!this.editable) {
            throw new IllegalStateException("can not edit this model since it is marked as none editable " + this);
        }
    }

    protected void setInit(boolean init) {
        this.init = init;
        this.clearCache();
    }

    protected void clearCache() {
        this.data = null;
    }

    protected void updateBeanList(boolean shouldChanged) {
        SwingValidator<P> parentValidator = this.getParentValidator();
        boolean wasChanged = parentValidator.isChanged();
        this.getChildsUpdator().setChilds(this.getBean(), this.data);
        parentValidator.doValidate();
        if (!shouldChanged && !wasChanged) {
            parentValidator.setChanged(false);
        }
    }
}

