/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.ref;

import com.google.common.base.Predicate;
import fr.ird.observe.DataService;
import fr.ird.observe.DecoratorService;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.entities.referentiel.ReferenceEntity;
import fr.ird.observe.ui.content.ContentUIInitializer;
import fr.ird.observe.ui.content.ref.ContentReferenceUI;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import jaxx.runtime.swing.editor.bean.BeanListHeader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.decorator.DecoratorUtil;
import org.nuiton.decorator.JXPathDecorator;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;

public class ReferentialContentUIInitializer<E extends ReferenceEntity, UI extends ContentReferenceUI<E>>
extends ContentUIInitializer<E, UI> {
    private static final Log log = LogFactory.getLog(ReferentialContentUIInitializer.class);

    public ReferentialContentUIInitializer(UI ui) {
        super(ui);
    }

    @Override
    protected void init(DataSource service, DecoratorService decoratorService, BeanListHeader beanList) throws DataSourceException {
        beanList.setI18nPrefix("observe.common.");
        if (log.isInfoEnabled()) {
            log.info((Object)("init list for " + beanList.getBeanType()));
        }
        if ("listHeader".equals(beanList.getName())) {
            ReferentialContentUIInitializer.prepareEntityList(service, beanList.getBeanType(), beanList, ((ContentReferenceUI)this.ui).getModel().getLoadBinder());
        } else {
            ReferentialContentUIInitializer.prepareEntityList(service, beanList.getBeanType(), beanList, null);
        }
        JList jlist = beanList.getList();
        Object init = jlist.getClientProperty("addDecorator");
        if (init != null) {
            Class klass = (Class)init;
            if (log.isDebugEnabled()) {
                log.debug((Object)("addDecorator to list " + jlist.getName()));
            }
            Decorator decorator = decoratorService.getDecoratorByType(klass);
            jlist.putClientProperty("decorator", decorator);
        }
        if ((init = jlist.getClientProperty("addToogleListSelectionModel")) != null && init instanceof Boolean && ((Boolean)init).booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("addToogleListSelectionModel to list " + jlist.getName()));
            }
            this.prepareToogleListSelectionModel(jlist);
        }
    }

    public static <E extends TopiaEntity> void prepareEntityList(DataSource storageService, Class<E> entityClass, BeanListHeader<E> list, TopiaEntityBinder<E> loador) throws DataSourceException {
        List data;
        ObserveContext tx = ObserveContext.get();
        Decorator decorator = tx.getDecorator(entityClass);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will use decorator " + decorator));
        }
        list.putClientProperty((Object)"decorator", (Object)decorator);
        if (ReferenceEntity.class.isAssignableFrom(entityClass)) {
            Predicate predicate = (Predicate)list.getClientProperty((Object)"listPredicate");
            data = tx.getDataService().getList(storageService, entityClass, predicate, loador);
        } else {
            data = new ArrayList();
        }
        DecoratorUtil.sort((JXPathDecorator)((JXPathDecorator)decorator), data, (int)0);
        list.init((JXPathDecorator)decorator, data);
        ListCellRenderer renderer = list.getList().getCellRenderer();
        list.getList().setCellRenderer(new ContentUIInitializer.ReferentielListCellRenderer(renderer));
        list.putClientProperty((Object)"data", data);
        ContentUIInitializer.EntityListPropertyChangeListener<E> listener = new ContentUIInitializer.EntityListPropertyChangeListener<E>(entityClass, list);
        DataService service = ObserveContext.get().getDataService();
        service.addReferentielPropertyChangeListener(entityClass, listener);
    }
}

