/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table.impl.longline;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import fr.ird.observe.entities.longline.Basket;
import fr.ird.observe.entities.longline.Baskets;
import fr.ird.observe.entities.longline.Branchline;
import fr.ird.observe.entities.longline.Branchlines;
import fr.ird.observe.entities.longline.LonglinePositionAware;
import fr.ird.observe.entities.longline.Section;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.collections4.CollectionUtils;
import org.nuiton.topia.persistence.TopiaId;

public class LonglinePositionHelper<E extends LonglinePositionAware> {
    List<Section> sectionUniverse;
    List<Basket> basketUniverse;
    final BeanComboBox<Section> uiSection;
    final BeanComboBox<Basket> uiBasket;
    final BeanComboBox<Branchline> uiBranchline;
    protected boolean locationIsAdjusting;

    public LonglinePositionHelper(BeanComboBox<Section> uiSection, BeanComboBox<Basket> uiBasket, BeanComboBox<Branchline> uiBranchline, E tableEditBean) {
        this.uiSection = uiSection;
        this.uiBasket = uiBasket;
        this.uiBranchline = uiBranchline;
        PropertyChangeListener sectionChanged = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LonglinePositionHelper.this.onSectionChanged((Section)evt.getNewValue(), (LonglinePositionAware)evt.getSource());
            }
        };
        tableEditBean.addPropertyChangeListener("section", sectionChanged);
        PropertyChangeListener basketChanged = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LonglinePositionHelper.this.onBasketChanged((Basket)evt.getNewValue(), (LonglinePositionAware)evt.getSource());
            }
        };
        tableEditBean.addPropertyChangeListener("basket", basketChanged);
    }

    public void initSections(List<Section> sections, List<E> entities) {
        this.sectionUniverse = sections;
        this.basketUniverse = Baskets.getBaskets(sections);
        List branchlineUniverse = Branchlines.getBranchlines(this.basketUniverse);
        ImmutableMap sectionsById = Maps.uniqueIndex(this.sectionUniverse, (Function)TopiaId.GET_TOPIA_ID);
        ImmutableMap basketsById = Maps.uniqueIndex(this.basketUniverse, (Function)TopiaId.GET_TOPIA_ID);
        ImmutableMap branchlinesById = Maps.uniqueIndex((Iterable)branchlineUniverse, (Function)TopiaId.GET_TOPIA_ID);
        if (CollectionUtils.isNotEmpty(entities)) {
            for (LonglinePositionAware entity : entities) {
                Branchline branchline;
                Basket basket;
                Section section = entity.getSection();
                if (section != null) {
                    section = (Section)sectionsById.get(section.getTopiaId());
                    entity.setSection(section);
                }
                if ((basket = entity.getBasket()) != null) {
                    basket = (Basket)basketsById.get(basket.getTopiaId());
                    entity.setBasket(basket);
                    Section section2 = this.getSection(basket);
                    entity.setSection(section2);
                }
                if ((branchline = entity.getBranchline()) == null) continue;
                branchline = (Branchline)branchlinesById.get(branchline.getTopiaId());
                entity.setBranchline(branchline);
                Basket basket2 = this.getBasket(branchline);
                entity.setBasket(basket2);
                Section section3 = this.getSection(basket2);
                entity.setSection(section3);
            }
        }
    }

    public void resetPosition(E entity) {
        Section section = entity.getSection();
        Basket basket = entity.getBasket();
        Branchline branchline = entity.getBranchline();
        this.uiBranchline.setSelectedItem(null);
        this.uiSection.setSelectedItem(null);
        this.uiBasket.setSelectedItem(null);
        if (section != null) {
            this.uiSection.setSelectedItem((Object)section);
        }
        if (basket != null) {
            this.uiBasket.setSelectedItem((Object)basket);
        }
        if (branchline != null) {
            this.uiBranchline.setSelectedItem((Object)branchline);
        }
    }

    public void savePosition(List<E> entities) {
        for (LonglinePositionAware entity : entities) {
            if (entity.getBasket() != null) {
                entity.setSection(null);
            }
            if (entity.getBranchline() == null) continue;
            entity.setBasket(null);
        }
    }

    public List<Section> getSectionUniverse() {
        return this.sectionUniverse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onSectionChanged(Section newValue, E entity) {
        this.locationIsAdjusting = true;
        try {
            Basket basket = entity.getBasket();
            Branchline branchline = entity.getBranchline();
            entity.setBasket(null);
            entity.setBranchline(null);
            this.uiBasket.setData(Collections.emptyList());
            this.uiBranchline.setData(Collections.emptyList());
            if (newValue != null) {
                List baskets = newValue.getBasket();
                this.uiBasket.setData(baskets);
                if (basket != null && baskets.contains(basket)) {
                    List branchlines = basket.getBranchline();
                    this.uiBranchline.setData(branchlines);
                    entity.setBasket(basket);
                    if (branchline != null && branchlines.contains(branchline)) {
                        entity.setBranchline(branchline);
                    }
                }
            }
        }
        finally {
            this.locationIsAdjusting = false;
        }
    }

    protected void onBasketChanged(Basket newValue, E entity) {
        if (!this.locationIsAdjusting) {
            Branchline branchline = entity.getBranchline();
            entity.setBranchline(null);
            this.uiBranchline.setData(Collections.emptyList());
            if (newValue != null) {
                List branchlines = newValue.getBranchline();
                this.uiBranchline.setData(branchlines);
                if (branchline != null && branchlines.contains(branchline)) {
                    entity.setBranchline(branchline);
                }
            }
        }
    }

    protected Section getSection(Basket basket) {
        Section result = null;
        for (Section section : this.sectionUniverse) {
            if (section.isBasketEmpty() || !section.getBasket().contains(basket)) continue;
            result = section;
            break;
        }
        return result;
    }

    protected Basket getBasket(Branchline branchline) {
        Basket result = null;
        for (Basket basket : this.basketUniverse) {
            if (basket.isBranchlineEmpty() || !basket.getBranchline().contains(branchline)) continue;
            result = basket;
            break;
        }
        return result;
    }
}

