/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.impl;

import fr.ird.observe.BinderService;
import fr.ird.observe.DBHelper;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.db.util.TopiaExecutor2;
import fr.ird.observe.entities.Activite;
import fr.ird.observe.entities.Calee;
import fr.ird.observe.entities.EchantillonThon;
import fr.ird.observe.entities.constants.TypeBancEnum;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIHandler;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.content.impl.CaleeUI;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import java.util.Date;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.BeanValidatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.BinderModelBuilder;

public class CaleeUIHandler
extends ContentUIHandler<Calee> {
    private static Log log = LogFactory.getLog(CaleeUIHandler.class);

    public CaleeUIHandler(CaleeUI ui) {
        super(ui, DataContextType.Activite, DataContextType.Calee);
    }

    public CaleeUI getUi() {
        return (CaleeUI)super.getUi();
    }

    public String updateTypeValue(Integer typeBan) {
        if (typeBan == null) {
            return I18n._((String)"observe.common.typeBanc.not.fill");
        }
        TypeBancEnum bancEnum = TypeBancEnum.valueOf((int)typeBan);
        return I18n._((String)bancEnum.getI18nKey());
    }

    @Override
    protected boolean computeCanWrite(DataSource source) {
        return source.canWriteData();
    }

    @Override
    protected TopiaEntityBinder<Calee> createOpeningBinder(BinderService binderService) {
        String binderName = this.getClass().getName() + "-open";
        TopiaEntityBinder r = binderService.getTopiaBinder(this.getBeanType(), binderName);
        if (r == null) {
            BinderModelBuilder builder = binderService.newBinderBuilder(Calee.class, new String[]{"commentaire", "nomSupply", "heureDebut", "heureFin", "heureFinCoulissage", "directionCourant", "vitesseCourant", "causeCoupNul", "epaisseurBanc", "profondeurMaximumEngin", "profondeurMoyenneBanc", "profondeurSommetBanc", "rejetThon", "rejetFaune", "typeBanc", "utilisationSonar", "echantillonThon", "echantillonFaune"});
            r = binderService.registerTopiaBinder(this.getBeanType(), builder, binderName);
        }
        return r;
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String caleeId = this.getSelectedId();
        if (caleeId == null) {
            return ContentMode.CREATE;
        }
        if (dataContext.isSelectedOpen(Activite.class)) {
            return ContentMode.UPDATE;
        }
        CaleeUIHandler.addMessage(this.getUi(), BeanValidatorScope.INFO, this.getEntityLabel(Activite.class), I18n._((String)"observe.message.activite.not.open"));
        return ContentMode.READ;
    }

    @Override
    public void openUI() throws Exception {
        super.openUI();
        String activiteId = this.getSelectedParentId();
        String caleeId = this.getSelectedId();
        if (log.isInfoEnabled()) {
            log.info((Object)("activiteId = " + activiteId));
            log.info((Object)("caleeId    = " + caleeId));
        }
        ContentMode mode = this.computeContentMode();
        DataService dataService = this.getDataService();
        Calee bean = (Calee)this.getBean();
        TopiaEntityBinder binder = this.getLoadBinder();
        DataSource source = this.getDataSource();
        if (caleeId == null) {
            dataService.preCreate(source, activiteId, (TopiaEntity)bean, binder, this.getPreCreateExecutor());
        } else {
            dataService.loadEditEntity(source, caleeId, this.getLoadExecutor());
        }
        this.setContentMode(mode);
        if (mode != ContentMode.READ) {
            this.getUi().startEdit(null);
        }
    }

    @Override
    protected Calee onPreCreate(TopiaContext tx, Object parent, Calee bean) throws TopiaException {
        Activite parentBean = (Activite)parent;
        Date date = DBHelper.getCurrentHour((Date)parentBean.getHeureObservation());
        bean.setHeureDebut(date);
        bean.setHeureFin(date);
        bean.setHeureFinCoulissage(date);
        int typeBanc = parentBean.getTypeBanc();
        bean.setTypeBanc(Integer.valueOf(typeBanc));
        return bean;
    }

    @Override
    protected void onLoad(TopiaContext tx, Calee bean) throws TopiaException {
        super.onLoad(tx, bean);
        Calee editBean = (Calee)this.getBean();
        if (!editBean.isEchantillonThonEmpty()) {
            for (EchantillonThon e : editBean.getEchantillonThon()) {
                e.isTailleThonEmpty();
            }
        }
        if (!editBean.isEchantillonFauneEmpty()) {
            for (EchantillonThon e : editBean.getEchantillonFaune()) {
                e.isTailleFauneEmpty();
            }
        }
    }

    @Override
    public void startEditUI(String ... binding) {
        ContentUIModel model = this.getModel();
        boolean create = model.getMode() == ContentMode.CREATE;
        String contextName = this.getValidatorContextName(model.getMode());
        this.getUi().getValidator().setContextName(contextName);
        if (create) {
            this.addInfoMessage(I18n._((String)"observe.message.creating.calee"));
        } else {
            this.addInfoMessage(I18n._((String)"observe.message.updating.calee"));
        }
        super.startEditUI("nomSupply.text", "commentaire2.text", "heureDebut.date", "heureFin.date", "heureFinCoulissage.date", "vitesseCourant.model", "directionCourant.model", "causeCoupNul.selectedItem", "utilisationSonar.selected", "vitesseCourant.model", "rejetFaune.booleanValue", "rejetThon.booleanValue", "epaisseurBanc.model", "typeBanc.text", "profondeurMaximumEngin.model", "profondeurMoyenneBanc.model", "profondeurSommetBanc.model");
        model.setModified(create);
    }

    @Override
    protected boolean doSave(Calee bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<Calee> binder) throws Exception {
        String activiteId = this.getSelectedParentId();
        if (bean.getTopiaId() == null) {
            dataService.create(dataSource, activiteId, (TopiaEntity)bean, binder, this.getCreateExecutor());
        } else {
            dataService.update(dataSource, null, (TopiaEntity)bean, this.getUpdateExecutor());
        }
        return true;
    }

    @Override
    protected Calee onCreate(TopiaContext tx, Object parent, Calee editBean) throws TopiaException {
        Activite parentBean = (Activite)parent;
        Calee beanToSave = (Calee)ObserveDAOHelper.getCaleeDAO((TopiaContext)tx).create(new Object[0]);
        editBean.setTopiaId(beanToSave.getTopiaId());
        parentBean.setCalee(beanToSave);
        return beanToSave;
    }

    @Override
    protected Calee onUpdate(TopiaContext tx, Object parentBean, Calee beanToSave) throws TopiaException {
        this.getLoadBinder().copyExcluding(this.getBean(), (Object)beanToSave, new String[]{"echantillonThon", "echantillonFaune"});
        return beanToSave;
    }

    @Override
    protected void afterSave(boolean refresh) {
        boolean create;
        super.afterSave(refresh);
        Calee bean = (Calee)this.getBean();
        BeanValidatorUtil.setValidatorChanged((JAXXObject)this.getUi(), (boolean)false, (String[])new String[0]);
        ObserveTreeHelper treeHelper = CaleeUIHandler.getTreeHelper((JAXXContext)this.getUi());
        ObserveNode node = (ObserveNode)treeHelper.getSelectedNode();
        boolean bl = create = node.getId() == null;
        if (create) {
            this.getModel().setMode(ContentMode.UPDATE);
            ObserveNode parentNode = (ObserveNode)treeHelper.removeNode((NavNode)node);
            node = treeHelper.addCalee(parentNode, bean);
            this.stopEditUI();
            treeHelper.selectNode((NavNode)node);
        } else {
            treeHelper.refreshNode((NavNode)node, false);
        }
    }

    @Override
    protected boolean doDelete(Calee bean, DataService dataService, DataSource dataSource, TopiaExecutor2<? extends TopiaEntity, Calee> deletor) throws Exception {
        if (this.askToDelete(bean)) {
            return false;
        }
        String activiteId = this.getSelectedParentId();
        dataService.delete(dataSource, activiteId, (TopiaEntity)bean, deletor);
        return true;
    }

    @Override
    protected void onDelete(TopiaContext tx, Object parent, Calee beanToDelete) {
        Activite parentBean = (Activite)parent;
        try {
            ObserveDAOHelper.getCaleeDAO((TopiaContext)tx).delete(parentBean.getCalee());
            parentBean.setCalee(null);
        }
        catch (TopiaException e) {
            throw new IllegalStateException("Could not delete calee " + beanToDelete, e);
        }
    }
}

