/*
 * #%L
 * Refcomp :: entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2012 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;

public abstract class UnitAbstract extends BusinessEntityImpl implements Unit {

    public static final List<WikittyExtension> extensions;

    public static final WikittyExtension extensionUnit;

    private static final long serialVersionUID = 7089005782580213350L;

    @Override
    public String getName() {
String value = UnitHelper.getName(getWikitty());
return value;
}

    @Override
    public void setName(String name) {
String oldValue = getName();
UnitHelper.setName(getWikitty(), name);
getPropertyChangeSupport().firePropertyChange(Unit.FIELD_UNIT_NAME, oldValue, getName());
}

    @Override
    public String getAddress() {
String value = UnitHelper.getAddress(getWikitty());
return value;
}

    @Override
    public void setAddress(String address) {
String oldValue = getAddress();
UnitHelper.setAddress(getWikitty(), address);
getPropertyChangeSupport().firePropertyChange(Unit.FIELD_UNIT_ADDRESS, oldValue, getAddress());
}

    @Override
    public String getFullName() {
String value = UnitHelper.getFullName(getWikitty());
return value;
}

    @Override
    public void setFullName(String fullName) {
String oldValue = getFullName();
UnitHelper.setFullName(getWikitty(), fullName);
getPropertyChangeSupport().firePropertyChange(Unit.FIELD_UNIT_FULLNAME, oldValue, getFullName());
}

    @Override
    public Set<String> getUnitDeptLink() {
Set<String> result = UnitHelper.getUnitDeptLink(getWikitty());
return result;
}

    @Override
    public void setUnitDeptLink(Set<String> unitDeptLink) {
Set<String> oldValue = getUnitDeptLink();
UnitHelper.setUnitDeptLink(getWikitty(), unitDeptLink);
getPropertyChangeSupport().firePropertyChange(Unit.FIELD_UNIT_UNITDEPTLINK, oldValue, getUnitDeptLink());
}

    @Override
    public void addAllUnitDeptLink(Collection<String> unitDeptLink) {
Set<String> oldValue = getUnitDeptLink();
UnitHelper.addAllUnitDeptLink(getWikitty(), unitDeptLink);
getPropertyChangeSupport().firePropertyChange(Unit.FIELD_UNIT_UNITDEPTLINK, oldValue, getUnitDeptLink());
}

    @Override
    public void addUnitDeptLink(String... element) {
Set<String> oldValue = getUnitDeptLink();
UnitHelper.addUnitDeptLink(getWikitty(), element);
getPropertyChangeSupport().firePropertyChange(Unit.FIELD_UNIT_UNITDEPTLINK, oldValue, getUnitDeptLink());
}

    @Override
    public void removeUnitDeptLink(String... element) {
Set<String> oldValue = getUnitDeptLink();
UnitHelper.removeUnitDeptLink(getWikitty(), element);
getPropertyChangeSupport().firePropertyChange(Unit.FIELD_UNIT_UNITDEPTLINK, oldValue, getUnitDeptLink());
}

    @Override
    public void clearUnitDeptLink() {
UnitHelper.clearUnitDeptLink(getWikitty());
getPropertyChangeSupport().firePropertyChange(Unit.FIELD_UNIT_UNITDEPTLINK, null, getUnitDeptLink());
}

    @Override
    public Set<UnitDeptLink> getUnitDeptLink(boolean exceptionIfNotLoaded) {
Set<UnitDeptLink> result = UnitHelper.getUnitDeptLink(getWikitty(), exceptionIfNotLoaded);
return result;
}

    @Override
    public void setUnitDeptLinkEntity(Collection<UnitDeptLink> unitDeptLink) {
Set<UnitDeptLink> oldValue = getUnitDeptLink(false);
UnitHelper.setUnitDeptLinkEntity(getWikitty(), unitDeptLink);
getPropertyChangeSupport().firePropertyChange(Unit.FIELD_UNIT_UNITDEPTLINK, oldValue, getUnitDeptLink());
}

    @Override
    public void addAllUnitDeptLinkEntity(Collection<UnitDeptLink> unitDeptLink) {
Set<UnitDeptLink> oldValue = getUnitDeptLink(false);
UnitHelper.addAllUnitDeptLinkEntity(getWikitty(), unitDeptLink);
getPropertyChangeSupport().firePropertyChange(Unit.FIELD_UNIT_UNITDEPTLINK, oldValue, getUnitDeptLink());
}

    @Override
    public void addUnitDeptLink(UnitDeptLink... element) {
Set<UnitDeptLink> oldValue = getUnitDeptLink(false);
UnitHelper.addUnitDeptLink(getWikitty(), element);
getPropertyChangeSupport().firePropertyChange(Unit.FIELD_UNIT_UNITDEPTLINK, oldValue, getUnitDeptLink());
}

    @Override
    public void removeUnitDeptLink(UnitDeptLink... element) {
Set<UnitDeptLink> oldValue = getUnitDeptLink(false);
UnitHelper.removeUnitDeptLink(getWikitty(), element);
getPropertyChangeSupport().firePropertyChange(Unit.FIELD_UNIT_UNITDEPTLINK, oldValue, getUnitDeptLink());
}

    public UnitAbstract() {
        super();
}

    public UnitAbstract(Wikitty wikitty) {
        super(wikitty);
}

    public UnitAbstract(BusinessEntityImpl businessEntityImpl) {
        super(businessEntityImpl.getWikitty());
}

    @Override
    public Collection<WikittyExtension> getStaticExtensions() {
        return extensions;
}

    static {
    
        extensionUnit = new WikittyExtension(EXT_UNIT,
                "3.0", // version
                WikittyUtil.tagValuesToMap(" version=\"3.0\""), // tag/values
                (List)null,
                WikittyUtil.buildFieldMapExtension( // building field map
                                                                 "String name", 
                                             "String address", 
                                             "String fullName", 
                                             "Wikitty unitDeptLink[0-*] allowed=\"UnitDeptLink\" unique=\"true\""));

        // init extensions
        List<WikittyExtension> exts = new ArrayList<WikittyExtension>();

        exts.add(extensionUnit);
        extensions = Collections.unmodifiableList(exts);

    }

    /**
     * Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call
     * @return 
     */
    @Override
    public String toString() {
        return UnitHelper.toString(getWikitty());
}

} //UnitAbstract
