/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util.ftp;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

public class FtpManager {
    private static final Log log = LogFactory.getLog(FtpManager.class);
    protected static FtpManager instance;
    protected String currentKey;
    protected FTPClient currentSession;

    public static FtpManager getInstance() {
        if (instance == null) {
            instance = new FtpManager();
        }
        return instance;
    }

    public synchronized FTPClient getFtpClient(String host, int port, String login, String password) throws IOException {
        FTPClient result;
        String key = String.format("%s:%s@%s:%d", login, password, host, port);
        if (this.currentSession != null && !this.currentKey.equals(key)) {
            this.closeFtpClient();
        }
        if (key.equals(this.currentKey)) {
            result = this.currentSession;
        } else {
            result = this.currentSession = this.openFtpClient(host, port, login, password);
            this.currentKey = key;
        }
        return result;
    }

    protected FTPClient openFtpClient(String host, int port, String login, String password) throws IOException {
        FTPClient ftp = new FTPClient();
        ftp.setConnectTimeout(5000);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Try to connect on %s:%d...", host, port));
        }
        ftp.connect(host, port);
        int reply = ftp.getReplyCode();
        if (FTPReply.isPositiveCompletion((int)reply)) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Connected to %s:%d", host, port));
            }
        } else {
            throw new IOException("can't connect");
        }
        boolean logged = ftp.login(login, password);
        if (logged) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Logged in with %s", login));
            }
        } else {
            throw new IOException("can't login");
        }
        ftp.enterLocalPassiveMode();
        ftp.setFileType(2);
        ftp.setDefaultTimeout(10000);
        ftp.setSoTimeout(10000);
        ftp.setDataTimeout(10000);
        ftp.setControlKeepAliveTimeout(30L);
        ftp.setControlKeepAliveReplyTimeout(10000);
        return ftp;
    }

    public synchronized void closeFtpClient() throws IOException {
        this.currentSession.disconnect();
        this.currentSession = null;
        this.currentKey = null;
    }

    public static long getFileSize(FTPClient ftpClient, String remotePath) throws IOException {
        long size = -1L;
        int replyCode = ftpClient.sendCommand("SIZE", remotePath);
        if (FTPReply.isPositiveCompletion((int)replyCode)) {
            String reply = ftpClient.getReplyString();
            try {
                String sizeStr = StringUtils.substringAfter((String)reply, (String)" ").replaceAll("\r\n", "");
                size = Long.parseLong(sizeStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return size;
    }
}

