/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.simulator;

import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.ObjectiveStorage;
import fr.ifremer.isisfish.datastore.OptimizationStorage;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.StorageChangeEvent;
import fr.ifremer.isisfish.datastore.StorageChangeListener;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.Observation;
import fr.ifremer.isisfish.export.ExportInfo;
import fr.ifremer.isisfish.simulator.Objective;
import fr.ifremer.isisfish.simulator.Optimization;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.FactorGroup;
import fr.ifremer.isisfish.ui.SimulationUI;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersParamModel;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersParamNameRenderer;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersParamValueEditor;
import fr.ifremer.isisfish.ui.models.common.ScriptParametersParamValueRenderer;
import fr.ifremer.isisfish.ui.models.optimization.ExportObservationTableModel;
import fr.ifremer.isisfish.ui.models.optimization.ExportTableCellEditor;
import fr.ifremer.isisfish.ui.models.optimization.ExportTableCellRenderer;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityInputUI;
import fr.ifremer.isisfish.ui.sensitivity.SensitivitySaveVerifier;
import fr.ifremer.isisfish.ui.simulator.OptimizationUI;
import fr.ifremer.isisfish.ui.simulator.SimulatorTabHandler;
import fr.ifremer.isisfish.ui.widget.editor.FactorEditorListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.JTable;
import jaxx.runtime.JAXXContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;

public class OptimizationHandler
extends SimulatorTabHandler {
    private static final Log log = LogFactory.getLog(OptimizationHandler.class);
    protected FactorEditorListener factorEditorListener;
    protected OptimizationUI tabUI;
    protected StorageChangeListener objectiveStorageListener;
    protected StorageChangeListener optimisationStorageListener;
    protected StorageChangeListener exportStorageListener;

    public OptimizationHandler(OptimizationUI tabUI) {
        super(tabUI);
        this.tabUI = tabUI;
    }

    protected void enableOptimization() {
        boolean selected = this.tabUI.fieldSimulUseOptimization.isSelected();
        this.getParameters().setUseOptimization(selected);
        this.setTabSelectedIcon((Component)((Object)this.tabUI), selected);
        this.tabUI.fieldExportList.clearSelection();
        this.tabUI.exportObservationTable.clearSelection();
    }

    protected void initFieldObjectiveMethodModel(StorageChangeEvent evt) {
        List result = ObjectiveStorage.getObjectiveNames().stream().filter(r -> r.endsWith(".java")).map(r -> r.substring(0, r.length() - 5)).collect(Collectors.toList());
        this.tabUI.fieldObjectiveMethodModel.setElementList(result);
    }

    protected void initFieldOptimizationMethodModel(StorageChangeEvent evt) {
        List result = OptimizationStorage.getOptimizationNames().stream().filter(r -> r.endsWith(".java")).map(r -> r.substring(0, r.length() - 5)).collect(Collectors.toList());
        this.tabUI.fieldOptimizationMethodModel.setElementList(result);
    }

    protected void initFieldExportListModel(StorageChangeEvent evt) {
        List result = ExportStorage.getExportNames().stream().filter(r -> r.endsWith(".java")).map(r -> r.substring(0, r.length() - 5)).collect(Collectors.toList());
        this.tabUI.fieldExportListModel.setElementList(result);
    }

    public void afterInit() {
        this.objectiveStorageListener = this::initFieldObjectiveMethodModel;
        ObjectiveStorage.addStorageListener(this.objectiveStorageListener);
        this.initFieldObjectiveMethodModel(null);
        this.optimisationStorageListener = this::initFieldOptimizationMethodModel;
        OptimizationStorage.addStorageListener(this.optimisationStorageListener);
        this.initFieldOptimizationMethodModel(null);
        this.exportStorageListener = this::initFieldExportListModel;
        ExportStorage.addStorageListener(this.exportStorageListener);
        this.initFieldExportListModel(null);
        this.tabUI.getExportObservationTable().setModel(this.getExportObservationTableModel());
    }

    public void refresh() {
        this.tabUI.fieldSimulUseOptimization.setSelected(this.getParameters().getUseOptimization());
        SimulationParameter param = this.getParameters();
        RegionStorage regionStorage = this.tabUI.getContextValue(RegionStorage.class);
        if (param.getObjective() != null) {
            this.tabUI.getFieldObjectiveMethodSelect().setSelectedItem(ObjectiveStorage.getName(param.getObjective()));
        }
        if (param.getOptimization() != null) {
            this.tabUI.getFieldOptimizationMethodSelect().setSelectedItem(OptimizationStorage.getName(param.getOptimization()));
        }
        this.tabUI.getExportObservationTable().setModel(this.getExportObservationTableModel());
        this.tabUI.getExportObservationTable().getColumnModel().getColumn(0).setCellRenderer(new ExportTableCellRenderer());
        ExportTableCellEditor editor = new ExportTableCellEditor();
        editor.setRegionStorage(regionStorage);
        this.tabUI.getExportObservationTable().getColumnModel().getColumn(1).setCellEditor(editor);
        this.tabUI.getExportObservationTable().getColumnModel().getColumn(1).setCellRenderer(new ExportTableCellRenderer());
    }

    public void objectiveChanged() {
        Objective objective;
        RegionStorage regionStorage;
        SimulationParameter param;
        block5: {
            String objectiveName = (String)this.tabUI.getFieldObjectiveMethodSelect().getSelectedItem();
            if (StringUtils.isBlank((CharSequence)objectiveName)) {
                return;
            }
            param = this.getParameters();
            regionStorage = this.tabUI.getContextValue(RegionStorage.class);
            objective = param.getObjective();
            if (objective == null || !objective.getClass().getSimpleName().equals(objectiveName)) {
                try {
                    ObjectiveStorage objectiveStorage = ObjectiveStorage.getObjective(objectiveName, new CodeSourceStorage.Location[0]);
                    objective = (Objective)objectiveStorage.getNewInstance();
                }
                catch (IsisFishException e) {
                    if (!log.isErrorEnabled()) break block5;
                    log.error((Object)"Can't set optimization", (Throwable)e);
                }
            }
        }
        if (objective != null) {
            param.setObjective(objective);
            ScriptParametersParamModel parametersTableModel = new ScriptParametersParamModel(objective);
            this.tabUI.getSimulObjectiveMethodParam().setModel(parametersTableModel);
            ScriptParametersParamNameRenderer nameRenderer = new ScriptParametersParamNameRenderer(objective);
            this.tabUI.getSimulObjectiveMethodParam().getColumnModel().getColumn(0).setCellRenderer(nameRenderer);
            ScriptParametersParamValueRenderer valueRenderer = new ScriptParametersParamValueRenderer();
            this.tabUI.getSimulObjectiveMethodParam().getColumnModel().getColumn(1).setCellRenderer(valueRenderer);
            ScriptParametersParamValueEditor editor = new ScriptParametersParamValueEditor(objective);
            editor.setRegionStorage(regionStorage);
            editor.setFactorActionListener(this.getFactorActionListener());
            this.tabUI.getSimulObjectiveMethodParam().getColumnModel().getColumn(1).setCellEditor(editor);
        }
    }

    protected FactorEditorListener getFactorActionListener() {
        if (this.factorEditorListener == null) {
            this.factorEditorListener = new FactorEditorListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    SensitivityInputUI sensitivityTabUI = new SensitivityInputUI((JAXXContext)OptimizationHandler.this.tabUI);
                    sensitivityTabUI.setContextValue(new SensitivitySaveVerifier());
                    sensitivityTabUI.setContextValue(OptimizationHandler.this.tabUI.getParentContainer(SimulationUI.class), "SimulationUI");
                    try {
                        RegionStorage regionStorage = OptimizationHandler.this.tabUI.getContextValue(RegionStorage.class);
                        TopiaContext tx = regionStorage.getStorage().beginTransaction();
                        FisheryRegion fisheryRegion = RegionStorage.getFisheryRegion(tx);
                        sensitivityTabUI.setFisheryRegion(fisheryRegion);
                        sensitivityTabUI.getHandler().setTreeModel();
                    }
                    catch (Exception ex) {
                        throw new IsisFishRuntimeException("Can't init dialog tree", ex);
                    }
                    JDialog dialog = new JDialog();
                    dialog.setTitle("S\u00e9lection d'un facteur");
                    dialog.add(sensitivityTabUI);
                    dialog.setSize(800, 600);
                    dialog.setLocationRelativeTo((Component)((Object)OptimizationHandler.this.tabUI));
                    dialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            FactorGroup factorGroup = OptimizationHandler.this.getFactorGroup();
                            if (factorGroup.size() > 0) {
                                Factor factor = factorGroup.get(factorGroup.size() - 1);
                                OptimizationHandler.this.removeFactor(factor.getPath());
                                this.setSelectedFactor(factor);
                            }
                        }
                    });
                    dialog.setVisible(true);
                }
            };
        }
        return this.factorEditorListener;
    }

    @Deprecated
    public void removeFactor(String factorPath) {
        this.removeFactor(this.getFactorGroup(), factorPath);
    }

    @Deprecated
    protected void removeFactor(FactorGroup factorGroup, String factorPath) {
        ArrayList<Factor> factorCopy = new ArrayList<Factor>(factorGroup.getFactors());
        for (Factor factor : factorCopy) {
            if (factor instanceof FactorGroup) {
                this.removeFactor((FactorGroup)factor, factorPath);
            }
            if (!factorPath.equals(factor.getPath())) continue;
            factorGroup.remove(factor);
        }
    }

    public void optimizationChanged() {
        Optimization optimization;
        RegionStorage regionStorage;
        SimulationParameter param;
        block5: {
            String optimizationName = (String)this.tabUI.getFieldOptimizationMethodSelect().getSelectedItem();
            if (StringUtils.isBlank((CharSequence)optimizationName)) {
                return;
            }
            param = this.getParameters();
            regionStorage = this.tabUI.getContextValue(RegionStorage.class);
            optimization = param.getOptimization();
            if (optimization == null || !optimization.getClass().getSimpleName().equals(optimizationName)) {
                try {
                    OptimizationStorage optimizationStorage = OptimizationStorage.getOptimization(optimizationName, new CodeSourceStorage.Location[0]);
                    optimization = (Optimization)optimizationStorage.getNewInstance();
                }
                catch (IsisFishException e) {
                    if (!log.isErrorEnabled()) break block5;
                    log.error((Object)"Can't set optimization", (Throwable)e);
                }
            }
        }
        if (optimization != null) {
            param.setOptimization(optimization);
            ScriptParametersParamModel parametersTableModel = new ScriptParametersParamModel(optimization);
            this.tabUI.getSimulOptimizationMethodParam().setModel(parametersTableModel);
            ScriptParametersParamNameRenderer nameRenderer = new ScriptParametersParamNameRenderer(optimization);
            this.tabUI.getSimulOptimizationMethodParam().getColumnModel().getColumn(0).setCellRenderer(nameRenderer);
            ScriptParametersParamValueRenderer valueRenderer = new ScriptParametersParamValueRenderer();
            this.tabUI.getSimulOptimizationMethodParam().getColumnModel().getColumn(1).setCellRenderer(valueRenderer);
            ScriptParametersParamValueEditor editor = new ScriptParametersParamValueEditor(optimization);
            editor.setRegionStorage(regionStorage);
            editor.setFactorActionListener(this.getFactorActionListener());
            this.tabUI.getSimulOptimizationMethodParam().getColumnModel().getColumn(1).setCellEditor(editor);
        }
    }

    public ExportObservationTableModel getExportObservationTableModel() {
        SimulationParameter param = this.getParameters();
        Map<ExportInfo, Observation> optimizationExportsObservations = param.getOptimizationExportsObservations();
        ExportObservationTableModel model = new ExportObservationTableModel(optimizationExportsObservations);
        return model;
    }

    public void addExports() {
        SimulationParameter param = this.getParameters();
        ExportObservationTableModel tableModel = (ExportObservationTableModel)this.tabUI.getExportObservationTable().getModel();
        List<String> selectedExports = this.tabUI.getFieldExportList().getSelectedValuesList();
        for (String selectedExport : selectedExports) {
            try {
                ExportStorage exportStorage = ExportStorage.getExport(selectedExport, new CodeSourceStorage.Location[0]);
                ExportInfo export = (ExportInfo)exportStorage.getNewInstance();
                Map<ExportInfo, Observation> optimizationExports = param.getOptimizationExportsObservations();
                optimizationExports.put(export, null);
                tableModel.setOptimizationExportsObservations(optimizationExports);
                param.setOptimizationExportsObservations(optimizationExports);
            }
            catch (IsisFishException ex) {
                throw new IsisFishRuntimeException("Can't create new export", ex);
            }
        }
    }

    public void removeExports() {
        SimulationParameter param = this.getParameters();
        Map<ExportInfo, Observation> optimizationExports = param.getOptimizationExportsObservations();
        ExportObservationTableModel tableModel = (ExportObservationTableModel)this.tabUI.getExportObservationTable().getModel();
        JTable table = this.tabUI.getExportObservationTable();
        int[] rows = table.getSelectedRows();
        for (int i = rows.length - 1; i >= 0; --i) {
            ExportInfo export = tableModel.getExportForRow(rows[i]);
            optimizationExports.remove(export);
            tableModel.deleteExport(export);
        }
        param.setOptimizationExportsObservations(optimizationExports);
    }
}

