/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: DownloadExportSqlResult.java 113 2011-11-23 19:08:01Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/trunk/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/export/DownloadExportSqlResult.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.export;

import fr.ifremer.echobase.services.ExportSqlService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

/**
 * Download the result of sql request in csv format.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class DownloadExportSqlResult extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    /** Sql request to execute. */
    protected String sql;

    /** Input stream of the file to download. */
    protected transient InputStream inputStream;

    /** File name of the download. */
    protected String fileName;

    /** Length of the file to download. */
    protected int contentLength;

    /** Content type of the file to download. */
    protected String contentType;

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public InputStream getInputStream() {
        return inputStream;
    }

    public String getFileName() {
        return fileName;
    }

    public int getContentLength() {
        return contentLength;
    }

    public String getContentType() {
        return contentType;
    }

    @Override
    public String execute() throws Exception {

        ExportSqlService service = newService(ExportSqlService.class);

        contentType = "text/csv";
        String content = service.createCsvFileContent(sql);
        contentLength = content.length();
        inputStream = new ByteArrayInputStream(content.getBytes());

        return SUCCESS;
    }
}
