/*
 * *##% 
 * vradi-services
 * Copyright (C) 2009 JurisMarches
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.services.dto;

import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.GroupBean;

import java.util.HashSet;

/**
 * User: chemit
 * Date: 29 oct. 2009
 * Time: 22:46:42
 */
public class VradiGroupDTO extends GroupBean implements VradiDTO<Group> {

    private static final long serialVersionUID = 1L;

    public VradiGroupDTO() {
        Group$client = new HashSet<String>();
        Group$user = new HashSet<String>();
        QueryMaker$queries = new HashSet<String>();
    }

    @Override
    public void fromWikitty(Group wikitty) {
        if (wikitty == null) {
            reset();
        } else {
            setWikittyId(wikitty.getWikittyId());
            setName(wikitty.getName());

            Group$client.clear();
            addAllClients(wikitty.getClient());

            Group$user.clear();
            addAllUsers(wikitty.getUser());

            QueryMaker$queries.clear();
            addAllQueries(wikitty.getQueries());
        }

    }

    @Override
    public void reset() {
        setWikittyId(null);
        setName(null);
        clearClient();
        clearQueries();
        clearUser();
    }

    @Override
    public void toWikitty(Group wikitty) {
        wikitty.setName(getName());

        wikitty.clearClient();
        for (String id : getClient()) {
            wikitty.addClient(id);
        }

        wikitty.clearUser();
        for (String id : getUser()) {
            wikitty.addUser(id);
        }

        wikitty.clearQueries();
        for (String id : getQueries()) {
            wikitty.addQueries(id);
        }
    }

    public void setWikittyId(String id) {
        String old = this.id;
        this.id = id;
        propertyChange.firePropertyChange("wikittyId", old, id);
    }

    public void addAllUsers(Iterable<String> element) {
        if (element != null) {
            for (String s : element) {
                Group$user.add(s);
            }
        }
        propertyChange.firePropertyChange("user", null, Group$user);
    }

    public void addAllClients(Iterable<String> element) {
        if (element != null) {
            for (String s : element) {
                Group$client.add(s);
            }
        }
        propertyChange.firePropertyChange("client", null, Group$client);
    }

    public void addAllQueries(Iterable<String> element) {
        if (element != null) {
            for (String s : element) {
                QueryMaker$queries.add(s);
            }
        }
        propertyChange.firePropertyChange("queries", null, QueryMaker$queries);
    }
}
