package com.franciaflex.faxtomail.web.action.admin;

/*
 * #%L
 * FaxToMail :: Web
 * $Id: ImportArchiveAction.java 660 2014-10-02 11:30:33Z kmorin $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-1.0/faxtomail-ui-web/src/main/java/com/franciaflex/faxtomail/web/action/admin/ImportArchiveAction.java $
 * %%
 * Copyright (C) 2014 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.InterceptorRefs;
import org.apache.struts2.convention.annotation.Result;

import com.franciaflex.faxtomail.services.service.EmailService;
import com.franciaflex.faxtomail.web.FaxToMailActionSupport;
import com.opensymphony.xwork2.Preparable;

/**
 * Action de reprise des archives.
 * 
 * @author Eric Chatellier
 */
@InterceptorRefs({
    @InterceptorRef("faxToMailInterceptor"),
    @InterceptorRef("loginInterceptor"),
    @InterceptorRef("paramsPrepareParamsStack")
})
public class ImportArchiveAction extends FaxToMailActionSupport implements Preparable {

    private static final Log log = LogFactory.getLog(ImportArchiveAction.class);

    protected String attachmentBase;

    protected File archiveFile;

    protected EmailService emailService;

    protected boolean disabledImport;

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }

    public void setArchiveFile(File archiveFile) {
        this.archiveFile = archiveFile;
    }

    public void setAttachmentBase(String attachmentBase) {
        this.attachmentBase = attachmentBase;
    }

    public boolean isDisabledImport() {
        return disabledImport;
    }

    @Override
    public void prepare() throws Exception {
        // check authorization
        if (!getSession().isAdmin()) {
            throw new RuntimeException("Not authorized");
        }
    }
    
    @Override
    @Action("import-archive-input")
    public String input() throws Exception {
        checkDisabled();
        return super.input();
    }

    protected boolean checkDisabled() {
        
        // pour eviter les erreurs, on considere que si 1000 mails archivés sont présents, il
        // proviennent de la reprise des archives
        if (emailService.getArchivedMailCount() > 1000) {
            disabledImport = true;
        }
        return disabledImport;
    }

    @Override
    public void validate() {
        if (StringUtils.isNotEmpty(attachmentBase) && !new File(attachmentBase).isDirectory()) {
            addActionError("Le répertoire de base des pièces jointes n'est pas un répertoire lisible !");
        }
        if (archiveFile == null) {
            addActionError("Le fichier d'archive est obligatoire !");
        }
        
        checkDisabled();
    }

    @Action(results = {@Result(type = "redirectAction", params = {"actionName", "import-archive-input"})})
    @Override
    public String execute() throws Exception {
        String result = INPUT;
        
        if (!checkDisabled()) {
            try (InputStream is = new FileInputStream(archiveFile)) {
                File file = new File(attachmentBase);
                emailService.importArchive(is, file);
                result = SUCCESS;
            } catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error("Can't import archive file", ex);
                }
                addActionError("Can't import archive " + ex.getMessage());
            }
        }
        return result;
    }
}
