package com.franciaflex.faxtomail.web;

/*
 * #%L
 * FaxToMail :: Web
 * $Id: FaxToMailLoginInterceptor.java 179 2014-06-10 09:21:07Z echatellier $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.2/faxtomail-ui-web/src/main/java/com/franciaflex/faxtomail/web/FaxToMailLoginInterceptor.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.Interceptor;

/**
 * Authentication interceptor.
 * 
 * @author Eric Chatellier
 */
public class FaxToMailLoginInterceptor implements Interceptor {

    /** serialVersionUID. */
    private static final long serialVersionUID = -5760224375232019437L;

    /*
     * @see com.opensymphony.xwork2.interceptor.Interceptor#init()
     */
    @Override
    public void init() {

    }

    public String intercept(ActionInvocation invocation) throws Exception {
        ActionContext context = invocation.getInvocationContext();
        FaxToMailSession session = (FaxToMailSession) context.getSession().get(FaxToMailSession.SESSION_PARAMETER);
        if (session == null || session.getAuthenticatedFaxToMailUser() == null) {
            return "redirect-to-login";
        } else {
            return invocation.invoke();
        }
    }

    /*
     * @see com.opensymphony.xwork2.interceptor.Interceptor#destroy()
     */
    @Override
    public void destroy() {

    }
}
