/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class ComponentResizer
extends MouseAdapter {
    public static final String DIRECTION_VERTICAL = "vertical";
    public static final String DIRECTION_HORIZONTAL = "horizontal";
    public static final String DIRECTION_BOTH = "both";
    private static final Dimension MINIMUM_SIZE = new Dimension(10, 10);
    private static final Dimension MAXIMUM_SIZE = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    private static Map<Integer, Integer> cursors = new HashMap<Integer, Integer>();
    private Insets dragInsets;
    private Dimension snapSize;
    private int direction;
    protected static final int NORTH = 1;
    protected static final int WEST = 2;
    protected static final int SOUTH = 4;
    protected static final int EAST = 8;
    private Cursor sourceCursor;
    private boolean resizing;
    private Rectangle bounds;
    private Point pressed;
    private boolean autoscrolls;
    private Dimension minimumSize = MINIMUM_SIZE;
    private Dimension maximumSize = MAXIMUM_SIZE;
    protected Map<Component, String> authorizedDirectionByComponent = new HashMap<Component, String>();

    public ComponentResizer() {
        this(new Insets(5, 5, 5, 5), new Dimension(1, 1), new Component[0]);
    }

    public ComponentResizer(Component ... components) {
        this(new Insets(5, 5, 5, 5), new Dimension(1, 1), components);
    }

    public ComponentResizer(Insets dragInsets, Component ... components) {
        this(dragInsets, new Dimension(1, 1), components);
    }

    public ComponentResizer(Insets dragInsets, Dimension snapSize, Component ... components) {
        this.setDragInsets(dragInsets);
        this.setSnapSize(snapSize);
        this.registerComponent(components);
    }

    public Insets getDragInsets() {
        return this.dragInsets;
    }

    public void setDragInsets(Insets dragInsets) {
        this.validateMinimumAndInsets(this.minimumSize, dragInsets);
        this.dragInsets = dragInsets;
    }

    public Dimension getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(Dimension maximumSize) {
        this.maximumSize = maximumSize;
    }

    public Dimension getMinimumSize() {
        return this.minimumSize;
    }

    public void setMinimumSize(Dimension minimumSize) {
        this.validateMinimumAndInsets(minimumSize, this.dragInsets);
        this.minimumSize = minimumSize;
    }

    public void deregisterComponent(Component ... components) {
        for (Component component : components) {
            component.removeMouseListener(this);
            component.removeMouseMotionListener(this);
            this.authorizedDirectionByComponent.remove(component);
        }
    }

    public void registerComponent(Component ... components) {
        this.registerComponent(DIRECTION_BOTH, components);
    }

    public void registerComponent(String authorizedDirection, Component ... components) {
        for (Component component : components) {
            component.addMouseListener(this);
            component.addMouseMotionListener(this);
            this.authorizedDirectionByComponent.put(component, authorizedDirection);
        }
    }

    public Dimension getSnapSize() {
        return this.snapSize;
    }

    public void setSnapSize(Dimension snapSize) {
        this.snapSize = snapSize;
    }

    private void validateMinimumAndInsets(Dimension minimum, Insets drag) {
        int minimumWidth = drag.left + drag.right;
        int minimumHeight = drag.top + drag.bottom;
        if (minimum.width < minimumWidth || minimum.height < minimumHeight) {
            String message = "Minimum size cannot be less than drag insets";
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Component source = e.getComponent();
        Point location = e.getPoint();
        this.direction = 0;
        String authorizedDirection = this.authorizedDirectionByComponent.get(source);
        if (location.x < this.dragInsets.left && !DIRECTION_VERTICAL.equals(authorizedDirection)) {
            this.direction += 2;
        }
        if (location.x > source.getWidth() - this.dragInsets.right - 1 && !DIRECTION_VERTICAL.equals(authorizedDirection)) {
            this.direction += 8;
        }
        if (location.y < this.dragInsets.top && !DIRECTION_HORIZONTAL.equals(authorizedDirection)) {
            ++this.direction;
        }
        if (location.y > source.getHeight() - this.dragInsets.bottom - 1 && !DIRECTION_HORIZONTAL.equals(authorizedDirection)) {
            this.direction += 4;
        }
        if (this.direction == 0) {
            source.setCursor(this.sourceCursor);
        } else {
            int cursorType = cursors.get(this.direction);
            Cursor cursor = Cursor.getPredefinedCursor(cursorType);
            source.setCursor(cursor);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.resizing) {
            Component source = e.getComponent();
            this.sourceCursor = source.getCursor();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.resizing) {
            Component source = e.getComponent();
            source.setCursor(this.sourceCursor);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.direction == 0) {
            return;
        }
        this.resizing = true;
        Component source = e.getComponent();
        this.pressed = e.getPoint();
        SwingUtilities.convertPointToScreen(this.pressed, source);
        this.bounds = source.getBounds();
        if (source instanceof JComponent) {
            JComponent jc = (JComponent)source;
            this.autoscrolls = jc.getAutoscrolls();
            jc.setAutoscrolls(false);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.resizing = false;
        Component source = e.getComponent();
        source.setCursor(this.sourceCursor);
        if (source instanceof JComponent) {
            ((JComponent)source).setAutoscrolls(this.autoscrolls);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.resizing) {
            return;
        }
        Component source = e.getComponent();
        Point dragged = e.getPoint();
        SwingUtilities.convertPointToScreen(dragged, source);
        this.changeBounds(source, this.direction, this.bounds, this.pressed, dragged);
    }

    protected void changeBounds(Component source, int direction, Rectangle bounds, Point pressed, Point current) {
        int maximum;
        int maximum2;
        int drag;
        int x = bounds.x;
        int y = bounds.y;
        int width = bounds.width;
        int height = bounds.height;
        if (2 == (direction & 2)) {
            drag = this.getDragDistance(pressed.x, current.x, this.snapSize.width);
            maximum2 = Math.min(width + x, this.maximumSize.width);
            drag = this.getDragBounded(drag, this.snapSize.width, width, this.minimumSize.width, maximum2);
            x -= drag;
            width += drag;
        }
        if (1 == (direction & 1)) {
            drag = this.getDragDistance(pressed.y, current.y, this.snapSize.height);
            maximum2 = Math.min(height + y, this.maximumSize.height);
            drag = this.getDragBounded(drag, this.snapSize.height, height, this.minimumSize.height, maximum2);
            y -= drag;
            height += drag;
        }
        if (8 == (direction & 8)) {
            drag = this.getDragDistance(current.x, pressed.x, this.snapSize.width);
            Dimension boundingSize = this.getBoundingSize(source);
            maximum = Math.min(boundingSize.width - x, this.maximumSize.width);
            drag = this.getDragBounded(drag, this.snapSize.width, width, this.minimumSize.width, maximum);
            width += drag;
        }
        if (4 == (direction & 4)) {
            drag = this.getDragDistance(current.y, pressed.y, this.snapSize.height);
            Dimension boundingSize = this.getBoundingSize(source);
            maximum = Math.min(boundingSize.height - y, this.maximumSize.height);
            drag = this.getDragBounded(drag, this.snapSize.height, height, this.minimumSize.height, maximum);
            height += drag;
        }
        source.setBounds(x, y, width, height);
        source.validate();
    }

    private int getDragDistance(int larger, int smaller, int snapSize) {
        int drag;
        int halfway = snapSize / 2;
        drag += (drag = larger - smaller) < 0 ? -halfway : halfway;
        drag = drag / snapSize * snapSize;
        return drag;
    }

    private int getDragBounded(int drag, int snapSize, int dimension, int minimum, int maximum) {
        while (dimension + drag < minimum) {
            drag += snapSize;
        }
        while (dimension + drag > maximum) {
            drag -= snapSize;
        }
        return drag;
    }

    private Dimension getBoundingSize(Component source) {
        if (source instanceof Window) {
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Rectangle bounds = env.getMaximumWindowBounds();
            return new Dimension(bounds.width, bounds.height);
        }
        return source.getParent().getSize();
    }

    static {
        cursors.put(1, 8);
        cursors.put(2, 10);
        cursors.put(4, 9);
        cursors.put(8, 11);
        cursors.put(3, 6);
        cursors.put(9, 7);
        cursors.put(6, 4);
        cursors.put(12, 5);
    }
}

