/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.actions;

import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.ui.swing.actions.AbstractFaxToMailAction;
import com.franciaflex.faxtomail.ui.swing.actions.GoToPreviousScreenAction;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeListUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeListUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.transmit.MailFolderChooserUI;
import com.franciaflex.faxtomail.ui.swing.content.transmit.MailFolderChooserUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.transmit.MailFolderChooserUIModel;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import jaxx.runtime.JAXXContext;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;

public class TransmitAction
extends AbstractFaxToMailAction<MailFolderChooserUIModel, MailFolderChooserUI, MailFolderChooserUIHandler> {
    public TransmitAction(MailFolderChooserUIHandler handler) {
        super(handler, false);
        this.setActionDescription(I18n.t((String)"faxtomail.action.transmit.tip", (Object[])new Object[0]));
    }

    public boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        MailFolderChooserUIModel model = (MailFolderChooserUIModel)this.getModel();
        ArrayList<DemandeUIModel> demandeUIModels = new ArrayList<DemandeUIModel>(model.getDemandeUIModels());
        for (final DemandeUIModel demandeUIModel : model.getDemandeUIModels()) {
            final MailFolder mailFolder = demandeUIModel.getMailFolder();
            List<DemandeUIModel> groupedDemandes = demandeUIModel.getGroupedDemandes();
            Collection sameFolderGroupedDemands = Collections2.filter(groupedDemandes, (Predicate)new Predicate<DemandeUIModel>(){

                public boolean apply(DemandeUIModel groupDemandeUIModel) {
                    return !demandeUIModel.equals(groupDemandeUIModel) && groupDemandeUIModel.getDemandStatus().isEditableStatus() && mailFolder.equals(groupDemandeUIModel.getMailFolder());
                }
            });
            if (sameFolderGroupedDemands.isEmpty()) continue;
            String groupedDemandTitles = "";
            for (DemandeUIModel groupedDemand : sameFolderGroupedDemands) {
                groupedDemandTitles = groupedDemandTitles + "- " + groupedDemand.getTitle() + "<br/>";
            }
            int i = JOptionPane.showConfirmDialog(null, I18n.t((String)"faxtomail.alert.transmit.groupedDemandsInSameFolder.message", (Object[])new Object[]{demandeUIModel.getTitle(), groupedDemandTitles}), I18n.t((String)"faxtomail.alert.transmit.groupedDemandsInSameFolder.title", (Object[])new Object[0]), 0, 3);
            if (i != 0) continue;
            demandeUIModels.addAll(sameFolderGroupedDemands);
        }
        model.setDemandeUIModels(demandeUIModels);
        return result;
    }

    @Override
    public void doAction() throws Exception {
        MailFolderChooserUIModel model = (MailFolderChooserUIModel)this.getModel();
        Collection emailIds = Collections2.transform(model.getDemandeUIModels(), (Function)new Function<DemandeUIModel, String>(){

            public String apply(DemandeUIModel demandeUIModel) {
                return demandeUIModel.getTopiaId();
            }
        });
        this.getContext().newServiceContext().getEmailService().transmit(emailIds, model.getMailFolder(), this.getContext().getCurrentUser());
    }

    public void postSuccessAction() {
        if (this.getContext().isUseFolderCache()) {
            this.getContext().getCurrentFolderEmails().removeAllDemands(((MailFolderChooserUIModel)this.getModel()).getDemandeUIModels());
        }
        super.postSuccessAction();
        MailFolderChooserUIHandler handler = (MailFolderChooserUIHandler)this.getHandler();
        FaxToMailUI parentUI = (FaxToMailUI)((MailFolderChooserUI)this.getUI()).getContextValue(JAXXContext.class, "parent");
        if (parentUI != null) {
            if (DemandeUI.class.isAssignableFrom(parentUI.getClass())) {
                this.getActionEngine().runInternalAction((AbstractApplicationUIHandler)handler, GoToPreviousScreenAction.class);
            } else if (DemandeListUI.class.isAssignableFrom(parentUI.getClass())) {
                DemandeListUI demandeListUI = (DemandeListUI)parentUI;
                DemandeListUIModel listModel = demandeListUI.getModel();
                ArrayList<DemandeUIModel> demandList = new ArrayList<DemandeUIModel>(listModel.getEmails());
                demandList.removeAll(((MailFolderChooserUIModel)this.getModel()).getDemandeUIModels());
                listModel.setEmails(demandList);
            }
        }
        handler.closeFrame();
    }
}

