package com.franciaflex.faxtomail.ui.swing.actions;

/*
 * #%L
 * FaxToMail :: UI
 * %%
 * Copyright (C) 2014 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.FaxToMailConfiguration;
import com.franciaflex.faxtomail.persistence.ProgressionModel;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailUIHandler;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import org.jdesktop.beans.AbstractBean;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;

/**
 * FaxToMail base action.
 *
 * @author kmorin - morin@codelutin.com
 */
public abstract class AbstractFaxToMailAction <M extends AbstractBean, UI extends FaxToMailUI<M, ?>, H extends AbstractFaxToMailUIHandler<M, UI>>
        extends AbstractApplicationAction<M, UI, H> {

    public abstract void doAction() throws Exception;

    protected AbstractFaxToMailAction(H handler, boolean hideBody) {
        super(handler, hideBody);
    }

    @Override
    public FaxToMailUIContext getContext() {
        return handler.getContext();
    }

    @Override
    protected ProgressionModel getProgressionModel() {
        return (ProgressionModel) getContext().getActionUI().getModel().getProgressionModel();
    }

    @Override
    protected FaxToMailConfiguration getConfig() {
        return getContext().getConfig();
    }

    @Override
    protected void sendMessage(String message) {
        getContext().showInformationMessage(message);
    }

    @Override
    protected void createProgressionModelIfRequired(int total) {
        ProgressionModel progressionModel = getProgressionModel();
        if (progressionModel == null) {
            progressionModel = new ProgressionModel();
            progressionModel.setTotal(total);
            progressionModel.setMessage("");
            progressionModel.setCurrent(0);
            setProgressionModel(progressionModel);
        } else {
            progressionModel.adaptTotal(total);
        }
    }
}
