/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class LongStreamRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`LongStreamRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to expressions dealing with `LongStream`s [Source](https://error-prone.picnic.tech/refasterrules/LongStreamRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new LongStreamClosedOpenRangeRecipe(), new ConcatOneLongStreamRecipe(), new ConcatTwoLongStreamsRecipe(), new LongStreamFilterSortedRecipe(), new LongStreamIsEmptyRecipe(), new LongStreamIsNotEmptyRecipe(), new LongStreamMinRecipe(), new LongStreamNoneMatchRecipe(), new LongStreamAnyMatchRecipe(), new LongStreamAllMatchRecipe(), new LongStreamTakeWhileRecipe()});
    }

    @NullMarked
    public static class LongStreamClosedOpenRangeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `LongStreamRules.LongStreamClosedOpenRange`";
        }

        public String getDescription() {
            return "Prefer `LongStream#range(long, long)` over the more contrived alternative";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"java.util.stream.LongStream.rangeClosed(#{from:any(long)}, #{to:any(long)} - 1)").build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.util.stream.LongStream.range(#{from:any(long)}, #{to:any(long)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.LongStream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.LongStream rangeClosed(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ConcatOneLongStreamRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `LongStreamRules.ConcatOneLongStream`";
        }

        public String getDescription() {
            return "Don't unnecessarily call `Streams#concat(LongStream...)`";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.collect.Streams.concat(#{stream:any(java.util.stream.LongStream)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesType("java.util.stream.LongStream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Streams concat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ConcatTwoLongStreamsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `LongStreamRules.ConcatTwoLongStreams`";
        }

        public String getDescription() {
            return "Prefer `LongStream#concat(LongStream, LongStream)` over the Guava alternative";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"com.google.common.collect.Streams.concat(#{s1:any(java.util.stream.LongStream)}, #{s2:any(java.util.stream.LongStream)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.util.stream.LongStream.concat(#{s1:any(java.util.stream.LongStream)}, #{s2:any(java.util.stream.LongStream)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesType("java.util.stream.LongStream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Streams concat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LongStreamFilterSortedRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `LongStreamRules.LongStreamFilterSorted`";
        }

        public String getDescription() {
            return "Apply `LongStream#filter(LongPredicate)` before `LongStream#sorted()` to reduce the number of elements to sort";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.sorted().filter(#{predicate:any(java.util.function.LongPredicate)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.filter(#{predicate:any(java.util.function.LongPredicate)}).sorted()").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.LongPredicate", Boolean.valueOf(true)), new UsesType("java.util.stream.LongStream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.LongStream filter(..)", true), new UsesMethod("java.util.stream.LongStream sorted(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LongStreamIsEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `LongStreamRules.LongStreamIsEmpty`";
        }

        public String getDescription() {
            return "In order to test whether a stream has any element, simply try to find one";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.count() == 0").build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.count() <= 0").build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.count() < 1").build();
                final JavaTemplate before$3 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.findFirst().isEmpty()").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.findAny().isEmpty()").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$3.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.LongStream", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.stream.LongStream count(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.OptionalLong isEmpty(..)", true), new UsesMethod("java.util.stream.LongStream findFirst(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LongStreamIsNotEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `LongStreamRules.LongStreamIsNotEmpty`";
        }

        public String getDescription() {
            return "In order to test whether a stream has any element, simply try to find one";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.count() != 0").build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.count() > 0").build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.count() >= 1").build();
                final JavaTemplate before$3 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.findFirst().isPresent()").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.findAny().isPresent()").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$3.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.LongStream", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.stream.LongStream count(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.OptionalLong isPresent(..)", true), new UsesMethod("java.util.stream.LongStream findFirst(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LongStreamMinRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `LongStreamRules.LongStreamMin`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongStreamMin {\n    \n    @BeforeTemplate\n    OptionalLong before(LongStream stream) {\n        return stream.sorted().findFirst();\n    }\n    \n    @AfterTemplate\n    OptionalLong after(LongStream stream) {\n        return stream.min();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.sorted().findFirst()").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.min()").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.OptionalLong", Boolean.valueOf(true)), new UsesType("java.util.stream.LongStream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.LongStream findFirst(..)", true), new UsesMethod("java.util.stream.LongStream sorted(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LongStreamNoneMatchRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `LongStreamRules.LongStreamNoneMatch`";
        }

        public String getDescription() {
            return "Prefer `LongStream#noneMatch(LongPredicate)` over more contrived alternatives";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"!#{stream:any(java.util.stream.LongStream)}.anyMatch(#{predicate:any(java.util.function.LongPredicate)})").build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.allMatch(#{predicate:any(java.util.function.LongPredicate)}.negate())").build();
                final JavaTemplate before$2 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.filter(#{predicate:any(java.util.function.LongPredicate)}).findAny().isEmpty()").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.noneMatch(#{predicate:any(java.util.function.LongPredicate)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$2.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.LongPredicate", Boolean.valueOf(true)), new UsesType("java.util.stream.LongStream", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.stream.LongStream anyMatch(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.OptionalLong isEmpty(..)", true), new UsesMethod("java.util.stream.LongStream filter(..)", true), new UsesMethod("java.util.stream.LongStream findAny(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.function.LongPredicate negate(..)", true), new UsesMethod("java.util.stream.LongStream allMatch(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LongStreamAnyMatchRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `LongStreamRules.LongStreamAnyMatch`";
        }

        public String getDescription() {
            return "Prefer `LongStream#anyMatch(LongPredicate)` over more contrived alternatives";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"!#{stream:any(java.util.stream.LongStream)}.noneMatch(#{predicate:any(java.util.function.LongPredicate)})").build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.filter(#{predicate:any(java.util.function.LongPredicate)}).findAny().isPresent()").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.anyMatch(#{predicate:any(java.util.function.LongPredicate)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.LongPredicate", Boolean.valueOf(true)), new UsesType("java.util.stream.LongStream", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.stream.LongStream noneMatch(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("java.util.OptionalLong isPresent(..)", true), new UsesMethod("java.util.stream.LongStream filter(..)", true), new UsesMethod("java.util.stream.LongStream findAny(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LongStreamAllMatchRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `LongStreamRules.LongStreamAllMatch`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongStreamAllMatch {\n    \n    @BeforeTemplate\n    boolean before(LongStream stream, LongPredicate predicate) {\n        return stream.noneMatch(predicate.negate());\n    }\n    \n    @AfterTemplate\n    boolean after(LongStream stream, LongPredicate predicate) {\n        return stream.allMatch(predicate);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.noneMatch(#{predicate:any(java.util.function.LongPredicate)}.negate())").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.allMatch(#{predicate:any(java.util.function.LongPredicate)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.LongPredicate", Boolean.valueOf(true)), new UsesType("java.util.stream.LongStream", Boolean.valueOf(true)), new UsesMethod("java.util.function.LongPredicate negate(..)", true), new UsesMethod("java.util.stream.LongStream noneMatch(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LongStreamTakeWhileRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `LongStreamRules.LongStreamTakeWhile`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class LongStreamTakeWhile {\n    \n    @BeforeTemplate\n    LongStream before(LongStream stream, LongPredicate predicate) {\n        return stream.takeWhile(predicate).filter(predicate);\n    }\n    \n    @AfterTemplate\n    LongStream after(LongStream stream, LongPredicate predicate) {\n        return stream.takeWhile(predicate);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.takeWhile(#{predicate:any(java.util.function.LongPredicate)}).filter(#{predicate})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{stream:any(java.util.stream.LongStream)}.takeWhile(#{predicate:any(java.util.function.LongPredicate)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.LongPredicate", Boolean.valueOf(true)), new UsesType("java.util.stream.LongStream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.LongStream filter(..)", true), new UsesMethod("java.util.stream.LongStream takeWhile(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

