/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal.progress;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.listener.AsyncRequestBodyListener;
import software.amazon.awssdk.core.async.listener.AsyncResponseTransformerListener;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.transfer.s3.CompletedObjectTransfer;
import software.amazon.awssdk.transfer.s3.TransferObjectRequest;
import software.amazon.awssdk.transfer.s3.TransferRequestOverrideConfiguration;
import software.amazon.awssdk.transfer.s3.internal.progress.DefaultTransferProgress;
import software.amazon.awssdk.transfer.s3.internal.progress.DefaultTransferProgressSnapshot;
import software.amazon.awssdk.transfer.s3.internal.progress.TransferListenerContext;
import software.amazon.awssdk.transfer.s3.internal.progress.TransferListenerFailedContext;
import software.amazon.awssdk.transfer.s3.internal.progress.TransferListenerInvoker;
import software.amazon.awssdk.transfer.s3.progress.TransferListener;
import software.amazon.awssdk.transfer.s3.progress.TransferProgress;
import software.amazon.awssdk.transfer.s3.progress.TransferProgressSnapshot;

@SdkInternalApi
public class TransferProgressUpdater {
    private final DefaultTransferProgress progress;
    private final TransferListenerContext context;
    private final TransferListenerInvoker listeners;
    private final CompletableFuture<Void> endOfStreamFuture;

    public TransferProgressUpdater(TransferObjectRequest request, AsyncRequestBody requestBody) {
        DefaultTransferProgressSnapshot.Builder snapshotBuilder = DefaultTransferProgressSnapshot.builder();
        TransferProgressUpdater.getContentLengthSafe(requestBody).ifPresent(snapshotBuilder::transferSizeInBytes);
        DefaultTransferProgressSnapshot snapshot = snapshotBuilder.build();
        this.progress = new DefaultTransferProgress(snapshot);
        this.context = TransferListenerContext.builder().request(request).progressSnapshot(snapshot).build();
        this.listeners = new TransferListenerInvoker(request.overrideConfiguration().map(TransferRequestOverrideConfiguration::listeners).orElseGet(Collections::emptyList));
        this.endOfStreamFuture = new CompletableFuture();
    }

    public TransferProgress progress() {
        return this.progress;
    }

    public void transferInitiated() {
        this.listeners.transferInitiated(this.context);
    }

    public AsyncRequestBody wrapRequestBody(AsyncRequestBody requestBody) {
        return AsyncRequestBodyListener.wrap((AsyncRequestBody)requestBody, (AsyncRequestBodyListener)new AsyncRequestBodyListener(){

            public void publisherSubscribe(Subscriber<? super ByteBuffer> subscriber) {
                TransferProgressUpdater.this.resetBytesTransferred();
            }

            public void subscriberOnNext(ByteBuffer byteBuffer) {
                TransferProgressUpdater.this.incrementBytesTransferred(byteBuffer.limit());
            }

            public void subscriberOnError(Throwable t) {
                TransferProgressUpdater.this.transferFailed(t);
            }

            public void subscriberOnComplete() {
                TransferProgressUpdater.this.endOfStreamFuture.complete(null);
            }
        });
    }

    public <ResultT> AsyncResponseTransformer<GetObjectResponse, ResultT> wrapResponseTransformer(AsyncResponseTransformer<GetObjectResponse, ResultT> responseTransformer) {
        return AsyncResponseTransformerListener.wrap(responseTransformer, (AsyncResponseTransformerListener)new AsyncResponseTransformerListener<GetObjectResponse>(){

            public void transformerOnResponse(GetObjectResponse response) {
                if (response.contentLength() != null) {
                    TransferProgressUpdater.this.progress.updateAndGet(b -> b.transferSizeInBytes(response.contentLength()));
                }
            }

            public void transformerExceptionOccurred(Throwable t) {
                TransferProgressUpdater.this.transferFailed(t);
            }

            public void publisherSubscribe(Subscriber<? super ByteBuffer> subscriber) {
                TransferProgressUpdater.this.resetBytesTransferred();
            }

            public void subscriberOnNext(ByteBuffer byteBuffer) {
                TransferProgressUpdater.this.incrementBytesTransferred(byteBuffer.limit());
            }

            public void subscriberOnError(Throwable t) {
                TransferProgressUpdater.this.transferFailed(t);
            }

            public void subscriberOnComplete() {
                TransferProgressUpdater.this.endOfStreamFuture.complete(null);
            }
        });
    }

    private void resetBytesTransferred() {
        this.progress.updateAndGet(b -> b.bytesTransferred(0L));
    }

    private void incrementBytesTransferred(int numBytes) {
        TransferProgressSnapshot snapshot = this.progress.updateAndGet(b -> b.bytesTransferred(b.getBytesTransferred() + (long)numBytes));
        this.listeners.bytesTransferred((TransferListener.Context.BytesTransferred)this.context.copy(b -> b.progressSnapshot(snapshot)));
    }

    public void registerCompletion(CompletableFuture<? extends CompletedObjectTransfer> future) {
        future.whenComplete((r, t) -> {
            if (t == null) {
                this.endOfStreamFuture.whenComplete((r2, t2) -> {
                    if (t2 == null) {
                        this.transferComplete((CompletedObjectTransfer)r);
                    } else {
                        this.transferFailed((Throwable)t2);
                    }
                });
            } else {
                this.transferFailed((Throwable)t);
            }
        });
    }

    private void transferComplete(CompletedObjectTransfer r) {
        this.listeners.transferComplete((TransferListener.Context.TransferComplete)this.context.copy(b -> {
            TransferProgressSnapshot snapshot = this.progress.snapshot();
            b.progressSnapshot(snapshot);
            b.completedTransfer(r);
        }));
    }

    private void transferFailed(Throwable t) {
        this.listeners.transferFailed(TransferListenerFailedContext.builder().transferContext((TransferListenerContext)this.context.copy(b -> b.progressSnapshot(this.progress.snapshot()))).exception(t).build());
    }

    private static Optional<Long> getContentLengthSafe(AsyncRequestBody requestBody) {
        if (requestBody == null) {
            return Optional.empty();
        }
        try {
            return requestBody.contentLength();
        }
        catch (Exception ignored) {
            return Optional.empty();
        }
    }
}

