/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.DBInstance;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartDbInstanceResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, StartDbInstanceResponse> {
    private static final SdkField<DBInstance> DB_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DBInstance").getter(StartDbInstanceResponse.getter(StartDbInstanceResponse::dbInstance)).setter(StartDbInstanceResponse.setter(Builder::dbInstance)).constructor(DBInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstance").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartDbInstanceResponse.memberNameToFieldInitializer();
    private final DBInstance dbInstance;

    private StartDbInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.dbInstance = builder.dbInstance;
    }

    public final DBInstance dbInstance() {
        return this.dbInstance;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstance());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDbInstanceResponse)) {
            return false;
        }
        StartDbInstanceResponse other = (StartDbInstanceResponse)((Object)obj);
        return Objects.equals(this.dbInstance(), other.dbInstance());
    }

    public final String toString() {
        return ToString.builder((String)"StartDbInstanceResponse").add("DBInstance", (Object)this.dbInstance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBInstance": {
                return Optional.ofNullable(clazz.cast(this.dbInstance()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<DBInstance>> map = new HashMap<String, SdkField<DBInstance>>();
        map.put("DBInstance", DB_INSTANCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartDbInstanceResponse, T> g) {
        return obj -> g.apply((StartDbInstanceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private DBInstance dbInstance;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDbInstanceResponse model) {
            super(model);
            this.dbInstance(model.dbInstance);
        }

        public final DBInstance.Builder getDbInstance() {
            return this.dbInstance != null ? this.dbInstance.toBuilder() : null;
        }

        public final void setDbInstance(DBInstance.BuilderImpl dbInstance) {
            this.dbInstance = dbInstance != null ? dbInstance.build() : null;
        }

        @Override
        public final Builder dbInstance(DBInstance dbInstance) {
            this.dbInstance = dbInstance;
            return this;
        }

        @Override
        public StartDbInstanceResponse build() {
            return new StartDbInstanceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartDbInstanceResponse> {
        public Builder dbInstance(DBInstance var1);

        default public Builder dbInstance(Consumer<DBInstance.Builder> dbInstance) {
            return this.dbInstance((DBInstance)((DBInstance.Builder)DBInstance.builder().applyMutation(dbInstance)).build());
        }
    }
}

