/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.embed.postgresql;

import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.io.ProcessOutput;
import de.flapdoodle.embed.process.config.store.IDownloadConfig;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.process.io.IStreamProcessor;
import de.flapdoodle.embed.process.io.LoggingOutputStreamProcessor;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.io.file.Files;
import de.flapdoodle.embed.process.io.progress.IProgressListener;
import de.flapdoodle.embed.process.io.progress.LoggingProgressListener;
import de.flapdoodle.embed.process.runtime.Executable;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import de.flapdoodle.embed.process.store.IArtifactStore;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import ru.yandex.qatools.embed.postgresql.AbstractPGProcess;
import ru.yandex.qatools.embed.postgresql.Command;
import ru.yandex.qatools.embed.postgresql.PackagePaths;
import ru.yandex.qatools.embed.postgresql.PostgresExecutable;
import ru.yandex.qatools.embed.postgresql.PostgresStarter;
import ru.yandex.qatools.embed.postgresql.config.AbstractPostgresConfig;
import ru.yandex.qatools.embed.postgresql.config.DownloadConfigBuilder;
import ru.yandex.qatools.embed.postgresql.config.PostgresConfig;
import ru.yandex.qatools.embed.postgresql.config.RuntimeConfigBuilder;
import ru.yandex.qatools.embed.postgresql.ext.ArtifactStoreBuilder;
import ru.yandex.qatools.embed.postgresql.ext.LogWatchStreamProcessor;
import ru.yandex.qatools.embed.postgresql.ext.PostgresArtifactStore;
import ru.yandex.qatools.embed.postgresql.util.ReflectUtil;

public class PostgresProcess
extends AbstractPGProcess<PostgresExecutable, PostgresProcess> {
    public static final int MAX_CREATEDB_TRIALS = 3;
    private static Logger logger = Logger.getLogger(PostgresProcess.class.getName());
    private final IRuntimeConfig runtimeConfig;
    volatile boolean processReady = false;
    boolean stopped = false;

    public PostgresProcess(Distribution distribution, PostgresConfig config, IRuntimeConfig runtimeConfig, PostgresExecutable executable) throws IOException {
        super(distribution, config, runtimeConfig, executable);
        this.runtimeConfig = runtimeConfig;
    }

    @Deprecated
    public static boolean shutdownPostgres(PostgresConfig config) {
        return PostgresProcess.shutdownPostgres(config, new RuntimeConfigBuilder().defaults(Command.PgCtl).build());
    }

    private static String runCmd(PostgresConfig config, IRuntimeConfig runtimeConfig, Command cmd, String successOutput, int timeout, String ... args) {
        return PostgresProcess.runCmd(config, runtimeConfig, cmd, successOutput, Collections.emptySet(), timeout, args);
    }

    private static String runCmd(PostgresConfig config, IRuntimeConfig runtimeConfig, Command cmd, String successOutput, Set<String> failOutput, long timeout, String ... args) {
        try {
            LogWatchStreamProcessor logWatch = new LogWatchStreamProcessor(successOutput, failOutput, (IStreamProcessor)new LoggingOutputStreamProcessor(logger, Level.ALL));
            IArtifactStore artifactStore = runtimeConfig.getArtifactStore();
            IDownloadConfig downloadCfg = ((PostgresArtifactStore)artifactStore).getDownloadConfig();
            try {
                ReflectUtil.setFinalField(downloadCfg, "_packageResolver", new PackagePaths(cmd));
                ReflectUtil.setFinalField(artifactStore, "_downloadConfig", downloadCfg);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Could not use the configured artifact store for cmd, falling back to default " + (Object)((Object)cmd), e);
                downloadCfg = new DownloadConfigBuilder().defaultsForCommand(cmd).progressListener((IProgressListener)new LoggingProgressListener(logger, Level.ALL)).build();
                artifactStore = new ArtifactStoreBuilder().defaults(cmd).download(downloadCfg).build();
            }
            IRuntimeConfig runtimeCfg = new RuntimeConfigBuilder().defaults(cmd).processOutput(new ProcessOutput((IStreamProcessor)logWatch, (IStreamProcessor)logWatch, (IStreamProcessor)logWatch)).artifactStore(artifactStore).commandLinePostProcessor(runtimeConfig.getCommandLinePostProcessor()).build();
            PostgresConfig postgresConfig = (PostgresConfig)((Object)new PostgresConfig(config).withArgs(args));
            if (Command.InitDb == cmd) {
                postgresConfig.withAdditionalInitDbParams(config.getAdditionalInitDbParams());
            }
            Executable exec = PostgresStarter.getCommand(cmd, runtimeCfg).prepare((IExecutableProcessConfig)postgresConfig);
            AbstractPGProcess proc = (AbstractPGProcess)exec.start();
            logWatch.waitForResult(timeout);
            proc.waitFor();
            return logWatch.getOutput();
        }
        catch (IOException | InterruptedException e) {
            logger.log(Level.WARNING, e.getMessage());
            return null;
        }
    }

    private static boolean shutdownPostgres(PostgresConfig config, IRuntimeConfig runtimeConfig) {
        try {
            return StringUtils.isEmpty((CharSequence)PostgresProcess.runCmd(config, runtimeConfig, Command.PgCtl, "server stopped", 2000, "stop"));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to stop postgres by pg_ctl!");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stopInternal() {
        PostgresProcess postgresProcess = this;
        synchronized (postgresProcess) {
            if (!this.stopped) {
                this.stopped = true;
                logger.info("trying to stop postgresql");
                if (!this.sendStopToPostgresqlInstance() && !this.sendTermToProcess() && this.waitUntilProcessHasStopped(2000)) {
                    logger.warning("could not stop postgresql with pg_ctl/SIGTERM, trying to kill it...");
                    if (!this.sendKillToProcess() && !this.tryKillToProcess() && this.waitUntilProcessHasStopped(3000)) {
                        logger.warning("could not kill postgresql within 4s!");
                    }
                }
            }
            if (!this.waitUntilProcessHasStopped(5000)) {
                logger.severe("Postgres has not been stopped within 10s! Something's wrong!");
            }
            this.deleteTempFiles();
        }
    }

    private boolean waitUntilProcessHasStopped(int timeoutMillis) {
        long started = System.currentTimeMillis();
        while (System.currentTimeMillis() - started < (long)timeoutMillis && this.isProcessRunning()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                logger.warning("Failed to wait with timeout until the process has been killed");
            }
        }
        return this.isProcessRunning();
    }

    protected final boolean sendStopToPostgresqlInstance() {
        IDirectory tempDir;
        boolean result = PostgresProcess.shutdownPostgres((PostgresConfig)this.getConfig(), this.runtimeConfig);
        if (this.runtimeConfig.getArtifactStore() instanceof PostgresArtifactStore && (tempDir = ((PostgresArtifactStore)this.runtimeConfig.getArtifactStore()).getTempDir()) != null && tempDir.asFile() != null) {
            logger.log(Level.INFO, String.format("Cleaning up after the embedded process (removing %s)...", tempDir.asFile().getAbsolutePath()));
            Files.forceDelete((File)tempDir.asFile());
        }
        return result;
    }

    protected void onBeforeProcess(IRuntimeConfig runtimeConfig) throws IOException {
        super.onBeforeProcess(runtimeConfig);
        PostgresConfig config = (PostgresConfig)this.getConfig();
        PostgresProcess.runCmd(config, runtimeConfig, Command.InitDb, "Success. You can now start the database server using", 1000, new String[0]);
    }

    protected List<String> getCommandLine(Distribution distribution, PostgresConfig config, IExtractedFileSet exe) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        switch (config.supportConfig().getName()) {
            case "postgres": {
                ret.addAll(Arrays.asList(exe.executable().getAbsolutePath(), "-p", String.valueOf(config.net().port()), "-h", config.net().host(), "-D", config.storage().dbDir().getAbsolutePath()));
                break;
            }
            case "pg_ctl": {
                ret.addAll(Arrays.asList(exe.executable().getAbsolutePath(), String.format("-o \"-p %s\" \"-h %s\"", config.net().port(), config.net().host()), "-D", config.storage().dbDir().getAbsolutePath(), "-w", "start"));
                break;
            }
            default: {
                throw new RuntimeException("Failed to launch Postgres: Unknown command " + config.supportConfig().getName() + "!");
            }
        }
        return ret;
    }

    protected void deleteTempFiles() {
        AbstractPostgresConfig.Storage storage = ((PostgresConfig)this.getConfig()).storage();
        if (storage.dbDir() != null && storage.isTmpDir() && !Files.forceDelete((File)storage.dbDir())) {
            logger.warning("Could not delete temp db dir: " + storage.dbDir());
        }
    }

    protected final void onAfterProcessStart(ProcessControl process, IRuntimeConfig runtimeConfig) throws IOException {
        Path pidFilePath = Paths.get(((PostgresConfig)this.getConfig()).storage().dbDir().getAbsolutePath(), "postmaster.pid");
        File pidFile = new File(pidFilePath.toAbsolutePath().toString());
        int timeout = 20000;
        while (!pidFile.exists() && (timeout -= 100) > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        int pid = -1;
        try {
            pid = Integer.valueOf((String)FileUtils.readLines((File)pidFilePath.toFile()).get(0));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, String.format("Failed to read PID file (%s)", e.getMessage()));
        }
        if (pid != -1) {
            this.setProcessId(pid);
        } else {
            this.setProcessId(PostgresProcess.getPidFromFile((File)this.pidFile()));
        }
        int trial = 0;
        do {
            String output = PostgresProcess.runCmd((PostgresConfig)this.getConfig(), runtimeConfig, Command.CreateDb, "", new HashSet<String>(Collections.singleton("database creation failed")), 3000L, ((PostgresConfig)this.getConfig()).storage().dbName());
            try {
                if (StringUtils.isEmpty((CharSequence)output) || !output.contains("could not connect to database")) break;
                logger.log(Level.WARNING, String.format("Could not create database first time (%s of %s trials)", trial, 3));
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (trial++ < 3);
    }

    public void importFromFile(File file) {
        this.importFromFileWithArgs(file, new String[0]);
    }

    public void importFromFileWithArgs(File file, String ... cliArgs) {
        if (file.exists()) {
            Object[] args = new String[]{"-U", ((PostgresConfig)this.getConfig()).credentials().username(), "-d", ((PostgresConfig)this.getConfig()).storage().dbName(), "-h", ((PostgresConfig)this.getConfig()).net().host(), "-p", String.valueOf(((PostgresConfig)this.getConfig()).net().port()), "-f", file.getAbsolutePath()};
            if (cliArgs != null && cliArgs.length != 0) {
                args = (String[])ArrayUtils.addAll((Object[])args, (Object[])cliArgs);
            }
            PostgresProcess.runCmd((PostgresConfig)this.getConfig(), this.runtimeConfig, Command.Psql, "", new HashSet<String>(Collections.singletonList("import into " + ((PostgresConfig)this.getConfig()).storage().dbName() + " failed")), 1000L, (String[])args);
        }
    }

    public void restoreFromFile(File file, String ... cliArgs) {
        if (file.exists()) {
            Object[] args = new String[]{"-U", ((PostgresConfig)this.getConfig()).credentials().username(), "-d", ((PostgresConfig)this.getConfig()).storage().dbName(), "-h", ((PostgresConfig)this.getConfig()).net().host(), "-p", String.valueOf(((PostgresConfig)this.getConfig()).net().port()), file.getAbsolutePath()};
            if (cliArgs != null && cliArgs.length != 0) {
                args = (String[])ArrayUtils.addAll((Object[])args, (Object[])cliArgs);
            }
            PostgresProcess.runCmd((PostgresConfig)this.getConfig(), this.runtimeConfig, Command.PgRestore, "", new HashSet<String>(Collections.singletonList("restore into " + ((PostgresConfig)this.getConfig()).storage().dbName() + " failed")), 1000L, (String[])args);
        }
    }

    public void exportToFile(File file) {
        PostgresProcess.runCmd((PostgresConfig)this.getConfig(), this.runtimeConfig, Command.PgDump, "", new HashSet<String>(Collections.singletonList("export from " + ((PostgresConfig)this.getConfig()).storage().dbName() + " failed")), 1000L, "-U", ((PostgresConfig)this.getConfig()).credentials().username(), "-d", ((PostgresConfig)this.getConfig()).storage().dbName(), "-h", ((PostgresConfig)this.getConfig()).net().host(), "-p", String.valueOf(((PostgresConfig)this.getConfig()).net().port()), "-f", file.getAbsolutePath());
    }

    public void exportSchemeToFile(File file) {
        PostgresProcess.runCmd((PostgresConfig)this.getConfig(), this.runtimeConfig, Command.PgDump, "", new HashSet<String>(Collections.singletonList("export from " + ((PostgresConfig)this.getConfig()).storage().dbName() + " failed")), 1000L, "-U", ((PostgresConfig)this.getConfig()).credentials().username(), "-d", ((PostgresConfig)this.getConfig()).storage().dbName(), "-h", ((PostgresConfig)this.getConfig()).net().host(), "-p", String.valueOf(((PostgresConfig)this.getConfig()).net().port()), "-f", file.getAbsolutePath(), "-s");
    }

    public void exportDataToFile(File file) {
        PostgresProcess.runCmd((PostgresConfig)this.getConfig(), this.runtimeConfig, Command.PgDump, "", new HashSet<String>(Collections.singletonList("export from " + ((PostgresConfig)this.getConfig()).storage().dbName() + " failed")), 1000L, "-U", ((PostgresConfig)this.getConfig()).credentials().username(), "-d", ((PostgresConfig)this.getConfig()).storage().dbName(), "-h", ((PostgresConfig)this.getConfig()).net().host(), "-p", String.valueOf(((PostgresConfig)this.getConfig()).net().port()), "-f", file.getAbsolutePath(), "-a");
    }

    public boolean isProcessReady() {
        return this.processReady;
    }

    @Override
    protected void cleanupInternal() {
    }
}

