/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.http.support;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentTypeResolver {
    private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private static final Logger LOG = LoggerFactory.getLogger(ContentTypeResolver.class);
    private static final Map<String, String> defaultContentTypeMap = new HashMap<String, String>();
    private static final Set<String> requiresCharset = new HashSet<String>();

    public static String get(String fileName) {
        String extension = FilenameUtils.getExtension((String)fileName).toLowerCase();
        if (defaultContentTypeMap.containsKey(extension)) {
            return defaultContentTypeMap.get(extension);
        }
        try {
            Class<?> fileTypeMapClass = ClassLoader.getSystemClassLoader().loadClass("javax.activation.FileTypeMap");
            LOG.debug("using {} to resolve contentType", (Object)fileTypeMapClass.getName());
            Object fileTypeMap = fileTypeMapClass.getMethod("getDefaultFileTypeMap", new Class[0]).invoke(fileTypeMapClass, new Object[0]);
            return (String)fileTypeMapClass.getMethod("getContentType", String.class).invoke(fileTypeMap, fileName);
        }
        catch (Exception e) {
            LOG.debug("FileTypeMap is not available (probably jdk5 is used). Exception {}, with message: {}", e.getClass(), (Object)e.getMessage());
            LOG.debug("Will use default content type: {} for fileName: {}", (Object)DEFAULT_CONTENT_TYPE, (Object)fileName);
            return DEFAULT_CONTENT_TYPE;
        }
    }

    public static String get(String fileName, String encoding) {
        String contentType = ContentTypeResolver.get(fileName);
        if (requiresCharset.contains(contentType)) {
            return contentType + "; charset=" + encoding;
        }
        return contentType;
    }

    static {
        defaultContentTypeMap.put("txt", "text/plain");
        defaultContentTypeMap.put("css", "text/css");
        defaultContentTypeMap.put("html", "text/html");
        defaultContentTypeMap.put("htm", "text/html");
        defaultContentTypeMap.put("xml", "application/xml");
        defaultContentTypeMap.put("xhtml", "application/xhtml+xml");
        defaultContentTypeMap.put("js", "application/javascript");
        defaultContentTypeMap.put("png", "image/png");
        defaultContentTypeMap.put("gif", "image/gif");
        defaultContentTypeMap.put("jpg", "image/jpeg");
        defaultContentTypeMap.put("jpeg", "image/jpeg");
        defaultContentTypeMap.put("eot", "application/vnd.ms-fontobject");
        defaultContentTypeMap.put("otf", "application/x-font-opentype");
        defaultContentTypeMap.put("svg", "image/svg+xml");
        requiresCharset.add("text/css");
        requiresCharset.add("text/html");
        requiresCharset.add("text/plain");
        requiresCharset.add("application/xml");
        requiresCharset.add("application/xhtml+xml");
        requiresCharset.add("application/javascript");
    }
}

