/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.support;

import java.util.HashMap;
import java.util.Map;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.decorator.ProcessorDecorator;
import ro.isdc.wro.model.resource.processor.impl.MultiLineCommentStripperProcessor;
import ro.isdc.wro.model.resource.processor.impl.SingleLineCommentStripperProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.ConformColorsCssProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.CssCompressorProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.CssDataUriPreProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.CssImportPreProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.CssMinProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.CssUrlRewritingProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.CssVariablesProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.DuplicatesAwareCssDataUriPreProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.FallbackCssDataUriProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.JawrCssMinifierProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.LessCssImportPreProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.VariablizeColorsCssProcessor;
import ro.isdc.wro.model.resource.processor.impl.js.ConsoleStripperProcessor;
import ro.isdc.wro.model.resource.processor.impl.js.JSMinProcessor;
import ro.isdc.wro.model.resource.processor.impl.js.SemicolonAppenderPreProcessor;
import ro.isdc.wro.model.resource.processor.support.ProcessorProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProcessorProvider
implements ProcessorProvider {
    @Override
    public Map<String, ResourcePreProcessor> providePreProcessors() {
        HashMap<String, ResourcePreProcessor> map = new HashMap<String, ResourcePreProcessor>();
        this.populateProcessorsMap(map);
        return map;
    }

    @Override
    public Map<String, ResourcePostProcessor> providePostProcessors() {
        return this.toPostProcessors(this.providePreProcessors());
    }

    private Map<String, ResourcePostProcessor> toPostProcessors(Map<String, ResourcePreProcessor> preProcessorsMap) {
        HashMap<String, ResourcePostProcessor> map = new HashMap<String, ResourcePostProcessor>();
        for (Map.Entry<String, ResourcePreProcessor> entry : preProcessorsMap.entrySet()) {
            map.put(entry.getKey(), new ProcessorDecorator(entry.getValue()));
        }
        return map;
    }

    private void populateProcessorsMap(Map<String, ResourcePreProcessor> map) {
        map.put("cssUrlRewriting", new CssUrlRewritingProcessor());
        map.put("cssImport", new CssImportPreProcessor());
        map.put("lessCssImport", new LessCssImportPreProcessor());
        map.put("cssVariables", new CssVariablesProcessor());
        map.put("cssCompressor", new CssCompressorProcessor());
        map.put("semicolonAppender", new SemicolonAppenderPreProcessor());
        map.put("cssDataUri", new CssDataUriPreProcessor());
        map.put("fallbackCssDataUri", new FallbackCssDataUriProcessor());
        map.put("duplicateAwareCssDataUri", new DuplicatesAwareCssDataUriPreProcessor());
        map.put("cssMinJawr", new JawrCssMinifierProcessor());
        map.put("cssMin", new CssMinProcessor());
        map.put("jsMin", new JSMinProcessor());
        map.put("variablizeColors", new VariablizeColorsCssProcessor());
        map.put("conformColors", new ConformColorsCssProcessor());
        map.put("singlelineStripper", new SingleLineCommentStripperProcessor());
        map.put("multilineStripper", new MultiLineCommentStripperProcessor());
        map.put("consoleStripper", new ConsoleStripperProcessor());
    }
}

