/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.decorator;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.ReadOnlyContext;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.processor.decorator.ProcessorDecorator;
import ro.isdc.wro.util.StopWatch;

public class BenchmarkProcessorDecorator
extends ProcessorDecorator {
    @Inject
    private ReadOnlyContext context;
    private static final Logger LOG = LoggerFactory.getLogger(BenchmarkProcessorDecorator.class);

    public BenchmarkProcessorDecorator(Object processor) {
        super(processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        StopWatch stopWatch = null;
        if (this.isDebug()) {
            stopWatch = new StopWatch();
            this.before(stopWatch);
        }
        try {
            super.process(resource, reader, writer);
        }
        finally {
            if (this.isDebug()) {
                this.after(stopWatch);
            }
        }
    }

    private boolean isDebug() {
        return this.context != null ? this.context.getConfig().isDebug() : true;
    }

    void before(StopWatch stopWatch) {
        stopWatch.start("Using " + this.toString());
    }

    void after(StopWatch stopWatch) {
        stopWatch.stop();
        LOG.debug(stopWatch.prettyPrint());
    }
}

