/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.impl.js;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.util.WroUtil;

@SupportedResourceType(value=ResourceType.JS)
public class SemicolonAppenderPreProcessor
implements ResourcePreProcessor {
    public static final String ALIAS = "semicolonAppender";
    private static final String PATTERN = WroUtil.loadRegexpWithKey("javascript.hasSemicolon");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        try {
            String script = IOUtils.toString((Reader)reader);
            writer.write(script);
            if (this.isSemicolonNeeded(script)) {
                writer.write(59);
            }
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    private boolean isSemicolonNeeded(String script) {
        return !script.matches(PATTERN) && !StringUtils.isEmpty((CharSequence)script);
    }
}

