/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.manager;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.cache.CacheKey;
import ro.isdc.wro.cache.CacheStrategy;
import ro.isdc.wro.cache.CacheValue;
import ro.isdc.wro.cache.factory.CacheKeyFactory;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.ReadOnlyContext;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.http.support.HttpHeader;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.util.WroUtil;

public class ResourceBundleProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceBundleProcessor.class);
    @Inject
    private CacheStrategy<CacheKey, CacheValue> cacheStrategy;
    @Inject
    private ReadOnlyContext context;
    @Inject
    private CacheKeyFactory cacheKeyFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serveProcessedBundle() throws IOException {
        String etagValue;
        CacheValue cacheValue;
        CacheKey cacheKey;
        ServletOutputStream os;
        HttpServletResponse response;
        WroConfiguration configuration;
        block6: {
            configuration = this.context.getConfig();
            HttpServletRequest request = this.context.getRequest();
            response = this.context.getResponse();
            os = null;
            try {
                cacheKey = this.getSafeCacheKey(request);
                this.initAggregatedFolderPath(request, cacheKey.getType());
                cacheValue = this.cacheStrategy.get(cacheKey);
                String ifNoneMatch = request.getHeader(HttpHeader.IF_NONE_MATCH.toString());
                etagValue = String.format("\"%s\"", cacheValue.getHash());
                if (etagValue == null || !etagValue.equals(ifNoneMatch)) break block6;
                LOG.debug("ETag hash detected: {}. Sending {} status code", (Object)etagValue, (Object)304);
                response.setStatus(304);
                if (os == null) return;
            }
            catch (Throwable throwable) {
                if (os == null) throw throwable;
                IOUtils.closeQuietly(os);
                throw throwable;
            }
            IOUtils.closeQuietly(os);
            return;
        }
        response.setContentType(cacheKey.getType().getContentType() + "; charset=" + configuration.getEncoding());
        response.setHeader(HttpHeader.ETAG.toString(), etagValue);
        os = response.getOutputStream();
        if (cacheValue.getRawContent() != null) {
            if (this.isGzipAllowed()) {
                response.setContentLength(cacheValue.getGzippedContent().length);
                response.setHeader(HttpHeader.CONTENT_ENCODING.toString(), "gzip");
                response.setHeader("Vary", "Accept-Encoding");
                IOUtils.write((byte[])cacheValue.getGzippedContent(), (OutputStream)os);
            } else {
                response.setContentLength(cacheValue.getRawContent().getBytes(configuration.getEncoding()).length);
                IOUtils.write((String)cacheValue.getRawContent(), (OutputStream)os, (String)configuration.getEncoding());
            }
        }
        if (os == null) return;
        IOUtils.closeQuietly((OutputStream)os);
    }

    private CacheKey getSafeCacheKey(HttpServletRequest request) {
        CacheKey cacheKey = this.cacheKeyFactory.create(request);
        if (cacheKey == null) {
            throw new WroRuntimeException("Cannot build valid CacheKey from request: " + request.getRequestURI());
        }
        return cacheKey;
    }

    private boolean isGzipAllowed() {
        return this.context.getConfig().isGzipEnabled() && WroUtil.isGzipSupported(this.context.getRequest());
    }

    private void initAggregatedFolderPath(HttpServletRequest request, ResourceType type) {
        if (ResourceType.CSS == type && this.context.getAggregatedFolderPath() == null) {
            String requestUri = request.getRequestURI();
            String cssFolder = StringUtils.removeEnd((String)requestUri, (String)FilenameUtils.getName((String)requestUri));
            String aggregatedFolder = StringUtils.removeStart((String)cssFolder, (String)request.getContextPath());
            LOG.debug("set aggregatedFolderPath: {}", (Object)aggregatedFolder);
            Context.get().setAggregatedFolderPath(aggregatedFolder);
        }
    }
}

