/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.http.support;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.http.support.DelegatingServletOutputStream;
import ro.isdc.wro.model.resource.locator.UriLocator;
import ro.isdc.wro.model.resource.locator.UrlUriLocator;

public class RedirectedStreamServletResponseWrapper
extends HttpServletResponseWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(RedirectedStreamServletResponseWrapper.class);
    private PrintWriter printWriter;
    private ServletOutputStream servletOutputStream;
    private final UriLocator externalResourceLocator = this.newExternalResourceLocator();

    protected UriLocator newExternalResourceLocator() {
        return new UrlUriLocator().setEnableWildcards(false);
    }

    public RedirectedStreamServletResponseWrapper(OutputStream outputStream, HttpServletResponse response) {
        super(response);
        Validate.notNull((Object)outputStream);
        this.printWriter = new PrintWriter(outputStream);
        this.servletOutputStream = new DelegatingServletOutputStream(outputStream);
    }

    public void sendError(int sc) throws IOException {
        this.onError(sc, "");
        super.sendError(sc);
    }

    public void sendError(int sc, String msg) throws IOException {
        this.onError(sc, msg);
        super.sendError(sc, msg);
    }

    private void onError(int sc, String msg) {
        LOG.debug("Error detected with code: {} and message: {}", (Object)sc, (Object)msg);
        ByteArrayOutputStream emptyStream = new ByteArrayOutputStream();
        this.printWriter = new PrintWriter(emptyStream);
        this.servletOutputStream = new DelegatingServletOutputStream(emptyStream);
    }

    public void sendRedirect(String location) throws IOException {
        try {
            LOG.debug("redirecting to: {}", (Object)location);
            InputStream is = this.externalResourceLocator.locate(location);
            IOUtils.copy((InputStream)is, (OutputStream)this.servletOutputStream);
            is.close();
            this.servletOutputStream.close();
        }
        catch (IOException e) {
            LOG.warn("{}: Invalid response for location: {}", (Object)e.getClass().getName(), (Object)location);
            throw e;
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.servletOutputStream;
    }

    public PrintWriter getWriter() throws IOException {
        return this.printWriter;
    }
}

