/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.impl.css;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.ReadOnlyContext;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.resource.locator.ClasspathUriLocator;
import ro.isdc.wro.model.resource.locator.ServletContextUriLocator;
import ro.isdc.wro.model.resource.locator.UrlUriLocator;
import ro.isdc.wro.model.resource.processor.impl.css.AbstractCssUrlRewritingProcessor;
import ro.isdc.wro.model.resource.support.DefaultResourceAuthorizationManager;
import ro.isdc.wro.model.resource.support.MutableResourceAuthorizationManager;
import ro.isdc.wro.model.resource.support.ResourceAuthorizationManager;

public class CssUrlRewritingProcessor
extends AbstractCssUrlRewritingProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CssUrlRewritingProcessor.class);
    public static final String ALIAS = "cssUrlRewriting";
    @Inject
    private ResourceAuthorizationManager authorizationManager;
    @Inject
    private ReadOnlyContext context;

    protected void onProcessCompleted() {
        if (this.authorizationManager instanceof DefaultResourceAuthorizationManager) {
            LOG.debug("allowed urls: {}", ((DefaultResourceAuthorizationManager)this.authorizationManager).list());
        }
    }

    protected void onUrlReplaced(String replacedUrl) {
        String allowedUrl = StringUtils.removeStart((String)replacedUrl, (String)this.getUrlPrefix());
        LOG.debug("adding allowed url: {}", (Object)allowedUrl);
        if (this.authorizationManager instanceof MutableResourceAuthorizationManager) {
            ((MutableResourceAuthorizationManager)this.authorizationManager).add(allowedUrl);
        }
    }

    protected String replaceImageUrl(String cssUri, String imageUrl) {
        if (ServletContextUriLocator.isValid(cssUri)) {
            if (ServletContextUriLocator.isValid(imageUrl)) {
                return imageUrl;
            }
            if (ServletContextUriLocator.isProtectedResource(cssUri)) {
                return this.getUrlPrefix() + this.computeNewImageLocation(cssUri, imageUrl);
            }
            String aggregatedPathPrefix = this.computeAggregationPathPrefix(this.context.getAggregatedFolderPath());
            LOG.debug("computed aggregatedPathPrefix {}", (Object)aggregatedPathPrefix);
            return this.computeNewImageLocation(aggregatedPathPrefix + cssUri, imageUrl);
        }
        if (UrlUriLocator.isValid(cssUri)) {
            if (ServletContextUriLocator.isValid(imageUrl)) {
                String externalServerCssUri = this.computeCssUriForExternalServer(cssUri);
                return this.computeNewImageLocation(externalServerCssUri, imageUrl);
            }
            return this.computeNewImageLocation(cssUri, imageUrl);
        }
        if (ClasspathUriLocator.isValid(cssUri)) {
            return this.getUrlPrefix() + this.computeNewImageLocation(cssUri, imageUrl);
        }
        throw new WroRuntimeException("Could not replace imageUrl: " + imageUrl + ", contained at location: " + cssUri);
    }

    private String computeCssUriForExternalServer(String cssUri) {
        String exernalServerCssUri = cssUri;
        try {
            String serverHost = cssUri.replace(new URL(cssUri).getPath(), "");
            exernalServerCssUri = serverHost + "/";
            LOG.debug("using {} host as cssUri", (Object)exernalServerCssUri);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return exernalServerCssUri;
    }

    private String computeAggregationPathPrefix(String aggregatedFolderPath) {
        LOG.debug("aggregatedFolderPath: {}", (Object)aggregatedFolderPath);
        String computedPrefix = "";
        if (aggregatedFolderPath != null) {
            String folderPrefix = "/..";
            StringBuffer result = new StringBuffer("");
            Object[] depthFolders = aggregatedFolderPath.split("/");
            LOG.debug("subfolders {}", (Object)Arrays.toString(depthFolders));
            for (Object folder : depthFolders) {
                if (StringUtils.isEmpty((CharSequence)folder)) continue;
                result.append("/..");
            }
            computedPrefix = result.toString().replaceFirst("/", "");
        }
        LOG.debug("computedPrefix: {}", (Object)computedPrefix);
        return computedPrefix;
    }

    private String computeNewImageLocation(String cssUri, String imageUrl) {
        LOG.debug("cssUri: {}, imageUrl {}", (Object)cssUri, (Object)imageUrl);
        String cleanImageUrl = this.cleanImageUrl(imageUrl);
        int idxLastSeparator = cssUri.lastIndexOf("/");
        if (idxLastSeparator == -1) {
            if (ClasspathUriLocator.isValid(cssUri) && (idxLastSeparator = cssUri.lastIndexOf("classpath:")) >= 0) {
                idxLastSeparator += "classpath:".length() - 1;
            }
            if (idxLastSeparator < 0) {
                throw new IllegalStateException("Invalid cssUri: " + cssUri + ". Should contain at least one '/' character!");
            }
        }
        String cssUriFolder = cssUri.substring(0, idxLastSeparator + 1);
        String processedImageUrl = cleanImageUrl.startsWith("/") ? cleanImageUrl.substring(1) : cleanImageUrl;
        String computedImageLocation = ro.isdc.wro.util.StringUtils.cleanPath(cssUriFolder + processedImageUrl);
        LOG.debug("computedImageLocation: {}", (Object)computedImageLocation);
        return computedImageLocation;
    }

    public final boolean isUriAllowed(String uri) {
        return this.authorizationManager.isAuthorized(uri);
    }
}

