/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.impl.css;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.processor.ImportAware;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.support.CssImportInspector;
import ro.isdc.wro.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedResourceType(value=ResourceType.CSS)
public abstract class AbstractCssImportPreProcessor
implements ResourcePreProcessor,
ImportAware {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCssImportPreProcessor.class);
    @Inject
    private UriLocatorFactory uriLocatorFactory;
    private final ThreadLocal<List<String>> processedImports = new ThreadLocal<List<String>>(){

        @Override
        protected List<String> initialValue() {
            return new ArrayList<String>();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void process(Resource resource, Reader reader, Writer writer) throws IOException {
        LOG.debug("Applying {} processor", (Object)this.toString());
        this.validate();
        try {
            String result = this.parseCss(resource, IOUtils.toString((Reader)reader), this.processedImports.get());
            writer.write(result);
        }
        finally {
            this.processedImports.get().clear();
            reader.close();
            writer.close();
        }
    }

    private void validate() {
        Validate.notNull((Object)this.uriLocatorFactory);
    }

    private String parseCss(Resource resource, String cssContent, List<String> processedImports) throws IOException {
        if (processedImports.contains(resource.getUri())) {
            LOG.debug("[WARN] Recursive import detected: {}", (Object)resource);
            this.onRecursiveImportDetected();
            return "";
        }
        String importedUri = resource.getUri().replace(File.separatorChar, '/');
        processedImports.add(importedUri);
        List<Resource> importedResources = this.findImportedResources(resource.getUri(), cssContent);
        return this.doTransform(cssContent, importedResources);
    }

    private List<Resource> findImportedResources(String resourceUri, String cssContent) throws IOException {
        ArrayList<Resource> imports = new ArrayList<Resource>();
        String css = cssContent;
        List<String> foundImports = this.findImports(css);
        for (String importUrl : foundImports) {
            Resource importedResource = this.createImportedResource(resourceUri, importUrl);
            if (imports.contains(importedResource)) {
                LOG.debug("[WARN] Duplicate imported resource: {}", (Object)importedResource);
                continue;
            }
            imports.add(importedResource);
            this.onImportDetected(importedResource.getUri());
        }
        return imports;
    }

    protected List<String> findImports(String css) {
        return new CssImportInspector(css).findImports();
    }

    private Resource createImportedResource(String resourceUri, String importUrl) {
        String absoluteUrl = this.computeAbsoluteUrl(resourceUri, importUrl);
        return Resource.create(absoluteUrl, ResourceType.CSS);
    }

    private String computeAbsoluteUrl(String relativeResourceUri, String importUrl) {
        String folder = FilenameUtils.getFullPath((String)relativeResourceUri);
        String absoluteImportUrl = StringUtils.cleanPath(folder + importUrl);
        return absoluteImportUrl;
    }

    protected abstract String doTransform(String var1, List<Resource> var2) throws IOException;

    protected void onImportDetected(String foundImportUri) {
    }

    protected void onRecursiveImportDetected() {
    }

    @Override
    public boolean isImportAware() {
        return true;
    }
}

