/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.WroModelInspector;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.group.InvalidGroupNameException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WroModel {
    private static final Logger LOG = LoggerFactory.getLogger(WroModel.class);
    private Set<Group> groups = new HashSet<Group>();

    public final Collection<Group> getGroups() {
        return Collections.unmodifiableSet(this.groups);
    }

    @Deprecated
    public final List<String> getGroupNames() {
        return new WroModelInspector(this).getGroupNames();
    }

    public final WroModel setGroups(Collection<Group> groups) {
        Validate.notNull(groups, (String)"groups cannot be null!", (Object[])new Object[0]);
        LOG.debug("setGroups: {}", groups);
        this.identifyDuplicateGroupNames(groups);
        this.groups = new HashSet<Group>(groups);
        return this;
    }

    @Deprecated
    public Collection<String> getGroupNamesContainingResource(String resourceUri) {
        return new WroModelInspector(this).getGroupNamesContainingResource(resourceUri);
    }

    private void identifyDuplicateGroupNames(Collection<Group> groups) {
        LOG.debug("identifyDuplicateGroupNames");
        ArrayList<String> groupNames = new ArrayList<String>();
        for (Group group : groups) {
            if (groupNames.contains(group.getName())) {
                throw new WroRuntimeException("Duplicate group name detected: " + group.getName());
            }
            groupNames.add(group.getName());
        }
    }

    @Deprecated
    public Group getGroupByName(String name) {
        WroModelInspector modelInspector = new WroModelInspector(this);
        Group group = modelInspector.getGroupByName(name);
        if (group == null) {
            throw new InvalidGroupNameException(String.format("There is no such group: '%s'. Available groups are: [%s]", name, modelInspector.getGroupNamesAsString()));
        }
        return group;
    }

    public void merge(WroModel importedModel) {
        Validate.notNull((Object)importedModel, (String)"imported model cannot be null!", (Object[])new Object[0]);
        LOG.debug("merging importedModel: {}", (Object)importedModel);
        for (String groupName : new WroModelInspector(importedModel).getGroupNames()) {
            if (new WroModelInspector(this).getGroupNames().contains(groupName)) {
                throw new WroRuntimeException("Duplicate group name detected: " + groupName);
            }
            Group importedGroup = new WroModelInspector(importedModel).getGroupByName(groupName);
            this.addGroup(importedGroup);
        }
    }

    public WroModel addGroup(Group group) {
        Validate.notNull((Object)group);
        this.groups.add(group);
        return this;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (boolean)true);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).append("groups", this.groups).toString();
    }
}

