/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.http;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.factory.PropertiesAndFilterConfigWroConfigurationFactory;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.http.handler.RequestHandler;
import ro.isdc.wro.http.handler.factory.DefaultRequestHandlerFactory;
import ro.isdc.wro.http.handler.factory.RequestHandlerFactory;
import ro.isdc.wro.http.support.ResponseHeadersConfigurer;
import ro.isdc.wro.http.support.ServletContextAttributeHelper;
import ro.isdc.wro.manager.WroManager;
import ro.isdc.wro.manager.factory.DefaultWroManagerFactory;
import ro.isdc.wro.manager.factory.WroManagerFactory;
import ro.isdc.wro.model.group.processor.Injector;
import ro.isdc.wro.model.group.processor.InjectorBuilder;
import ro.isdc.wro.model.resource.locator.support.DispatcherStreamLocator;
import ro.isdc.wro.util.ObjectFactory;
import ro.isdc.wro.util.WroUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WroFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(WroFilter.class);
    private static final String MBEAN_PREFIX = "wro4j-";
    private FilterConfig filterConfig;
    private WroConfiguration wroConfiguration;
    private WroManagerFactory wroManagerFactory;
    private RequestHandlerFactory requestHandlerFactory = this.newRequestHandlerFactory();
    private ResponseHeadersConfigurer headersConfigurer;
    private boolean enable = true;
    private Injector injector;

    public final void init(FilterConfig config) throws ServletException {
        this.filterConfig = config;
        this.wroConfiguration = this.wroConfiguration == null ? this.createConfiguration() : this.wroConfiguration;
        this.wroManagerFactory = this.createWroManagerFactory();
        this.headersConfigurer = this.newResponseHeadersConfigurer();
        this.registerChangeListeners();
        this.initJMX();
        this.doInit(config);
    }

    private WroConfiguration createConfiguration() {
        WroConfiguration configAttribute = ServletContextAttributeHelper.create(this.filterConfig).getWroConfiguration();
        return configAttribute != null ? configAttribute : this.newWroConfigurationFactory(this.filterConfig).create();
    }

    private WroManagerFactory createWroManagerFactory() {
        if (this.wroManagerFactory == null) {
            WroManagerFactory managerFactoryAttribute = ServletContextAttributeHelper.create(this.filterConfig).getManagerFactory();
            LOG.debug("managerFactory attribute: {}", (Object)managerFactoryAttribute);
            return managerFactoryAttribute != null ? managerFactoryAttribute : this.newWroManagerFactory();
        }
        LOG.debug("created managerFactory: {}", (Object)this.wroManagerFactory);
        return this.wroManagerFactory;
    }

    private void initJMX() {
        try {
            ObjectName name;
            MBeanServer mbeanServer;
            if (this.wroConfiguration.isJmxEnabled() && !(mbeanServer = this.getMBeanServer()).isRegistered(name = new ObjectName(this.newMBeanName(), "type", WroConfiguration.class.getSimpleName()))) {
                mbeanServer.registerMBean(this.wroConfiguration, name);
            }
            LOG.info("wro4j version: {}", (Object)WroUtil.getImplementationVersion());
            LOG.info("wro4j configuration: {}", (Object)this.wroConfiguration);
        }
        catch (JMException e) {
            LOG.error("Exception occured while registering MBean", (Throwable)e);
        }
    }

    protected String newMBeanName() {
        String mbeanName = this.wroConfiguration.getMbeanName();
        if (StringUtils.isEmpty((CharSequence)mbeanName)) {
            String contextPath = this.getContextPath();
            mbeanName = StringUtils.isEmpty((CharSequence)contextPath) ? "ROOT" : contextPath;
            mbeanName = MBEAN_PREFIX + mbeanName;
        }
        return mbeanName;
    }

    private String getContextPath() {
        String contextPath = null;
        try {
            contextPath = (String)ServletContext.class.getMethod("getContextPath", new Class[0]).invoke((Object)this.filterConfig.getServletContext(), new Object[0]);
        }
        catch (Exception e) {
            contextPath = "DEFAULT";
            LOG.warn("Couldn't identify contextPath because you are using older version of servlet-api (<2.5). Using " + contextPath + " contextPath.");
        }
        return contextPath.replaceFirst("/", "");
    }

    protected MBeanServer getMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    private void registerChangeListeners() {
        this.wroConfiguration.registerCacheUpdatePeriodChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                WroFilter.this.headersConfigurer = WroFilter.this.newResponseHeadersConfigurer();
                WroFilter.this.wroManagerFactory.onCachePeriodChanged(WroFilter.this.valueAsLong(event.getNewValue()));
            }
        });
        this.wroConfiguration.registerModelUpdatePeriodChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                WroFilter.this.headersConfigurer = WroFilter.this.newResponseHeadersConfigurer();
                WroFilter.this.wroManagerFactory.onModelPeriodChanged(WroFilter.this.valueAsLong(event.getNewValue()));
            }
        });
        LOG.debug("Cache & Model change listeners were registered");
    }

    protected ResponseHeadersConfigurer newResponseHeadersConfigurer() {
        return new ResponseHeadersConfigurer(this.wroConfiguration.getHeader()){

            @Override
            public void configureDefaultHeaders(Map<String, String> map) {
                3.useDefaultsFromConfig(WroFilter.this.wroConfiguration, map);
                WroFilter.this.configureDefaultHeaders(map);
            }
        };
    }

    protected RequestHandlerFactory newRequestHandlerFactory() {
        return new DefaultRequestHandlerFactory();
    }

    private long valueAsLong(Object value) {
        Validate.notNull((Object)value);
        return Long.valueOf(String.valueOf(value));
    }

    @Deprecated
    protected void configureDefaultHeaders(Map<String, String> map) {
    }

    protected void doInit(FilterConfig config) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (this.isFilterActive(request)) {
            try {
                Context.set(Context.webContext(request, response, this.filterConfig), this.wroConfiguration);
                if (!this.handledWithRequestHandler(request, response)) {
                    this.processRequest(request, response);
                    this.onRequestProcessed();
                }
                this.onProcessComplete();
            }
            catch (Exception e) {
                this.onException(e, response, chain);
            }
            finally {
                Context.unset();
            }
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private void onProcessComplete() {
        if (this.wroConfiguration.isDisableCache()) {
            LOG.debug("Disable Cache is true. Destroying model...");
            WroManager manager = (WroManager)this.wroManagerFactory.create();
            manager.getModelFactory().destroy();
            manager.getCacheStrategy().clear();
        }
    }

    private boolean handledWithRequestHandler(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Collection handlers = (Collection)this.requestHandlerFactory.create();
        Validate.notNull((Object)handlers, (String)"requestHandlers cannot be null!", (Object[])new Object[0]);
        Injector injector = this.getInjector();
        for (RequestHandler requestHandler : handlers) {
            injector.inject(requestHandler);
            if (!requestHandler.isEnabled() || !requestHandler.accept(request)) continue;
            requestHandler.handle(request, response);
            return true;
        }
        return false;
    }

    Injector getInjector() {
        if (this.injector == null) {
            this.injector = InjectorBuilder.create(this.wroManagerFactory).build();
        }
        return this.injector;
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.setResponseHeaders(response);
        ((WroManager)this.wroManagerFactory.create()).process();
    }

    private boolean isFilterActive(HttpServletRequest request) {
        return this.enable && !DispatcherStreamLocator.isIncludedRequest(request);
    }

    protected void onException(Exception e, HttpServletResponse response, FilterChain chain) {
        RuntimeException re = e instanceof RuntimeException ? (RuntimeException)e : new WroRuntimeException(e.getMessage(), e);
        this.onRuntimeException(re, response, chain);
    }

    @Deprecated
    protected void onRuntimeException(RuntimeException e, HttpServletResponse response, FilterChain chain) {
        LOG.debug("Exception occured", (Throwable)e);
        try {
            LOG.debug("Cannot process. Proceeding with chain execution.");
            chain.doFilter((ServletRequest)Context.get().getRequest(), (ServletResponse)response);
        }
        catch (Exception ex) {
            LOG.debug("Error while chaining the request", (Throwable)e);
        }
    }

    protected void setResponseHeaders(HttpServletResponse response) {
        this.headersConfigurer.setHeaders(response);
    }

    public void setWroManagerFactory(WroManagerFactory wroManagerFactory) {
        this.wroManagerFactory = wroManagerFactory;
    }

    public final WroManagerFactory getWroManagerFactory() {
        return this.wroManagerFactory;
    }

    public void setRequestHandlerFactory(RequestHandlerFactory requestHandlerFactory) {
        Validate.notNull((Object)requestHandlerFactory);
        this.requestHandlerFactory = requestHandlerFactory;
    }

    protected WroManagerFactory newWroManagerFactory() {
        return new DefaultWroManagerFactory(this.wroConfiguration);
    }

    protected ObjectFactory<WroConfiguration> newWroConfigurationFactory(FilterConfig filterConfig) {
        return new PropertiesAndFilterConfigWroConfigurationFactory(filterConfig);
    }

    public final WroConfiguration getConfiguration() {
        return this.wroConfiguration;
    }

    public final void setConfiguration(WroConfiguration config) {
        Validate.notNull((Object)config);
        this.wroConfiguration = config;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    protected void onRequestProcessed() {
    }

    public void destroy() {
        if (this.wroManagerFactory != null) {
            this.wroManagerFactory.destroy();
        }
        if (this.wroConfiguration != null) {
            this.wroConfiguration.destroy();
        }
        Context.destroy();
    }
}

