/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.util.provider;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.util.WroUtil;
import ro.isdc.wro.util.provider.ConfigurableProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderFinder<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ProviderFinder.class);
    private Class<T> type;

    ProviderFinder(Class<T> type) {
        this.type = type;
    }

    public static <T> ProviderFinder<T> of(Class<T> type) {
        return new ProviderFinder<T>(type);
    }

    public List<T> find() {
        ArrayList<T> providers = new ArrayList<T>();
        try {
            Iterator<T> iterator = this.lookupProviders(this.type);
            while (iterator.hasNext()) {
                T provider = iterator.next();
                LOG.debug("found provider: {}", provider);
                providers.add(provider);
            }
            this.collectConfigurableProviders(providers);
        }
        catch (Exception e) {
            LOG.error("Failed to discover providers using ServiceRegistry. Cannot continue...", (Throwable)e);
            WroUtil.wrapWithWroRuntimeException(e);
        }
        return providers;
    }

    private void collectConfigurableProviders(List<T> providers) {
        if (this.type.isAssignableFrom(ConfigurableProvider.class)) {
            Iterator<ConfigurableProvider> iterator = this.lookupProviders(ConfigurableProvider.class);
            while (iterator.hasNext()) {
                ConfigurableProvider provider = iterator.next();
                LOG.debug("found provider: {}", (Object)provider);
                providers.add(provider);
            }
        }
    }

    <P> Iterator<P> lookupProviders(Class<P> clazz) {
        LOG.debug("searching for providers of type : {}", clazz);
        return ServiceRegistry.lookupProviders(clazz);
    }
}

