/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.support.naming;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import ro.isdc.wro.model.resource.support.hash.CRC32HashStrategy;
import ro.isdc.wro.model.resource.support.hash.HashStrategy;
import ro.isdc.wro.model.resource.support.naming.NamingStrategy;

public class HashEncoderNamingStrategy
implements NamingStrategy {
    public static final String ALIAS = "hashEncoder-CRC32";
    private HashStrategy hashStrategy = this.newHashStrategy();

    protected HashStrategy newHashStrategy() {
        return new CRC32HashStrategy();
    }

    public String rename(String originalName, InputStream inputStream) throws IOException {
        String baseName = FilenameUtils.getBaseName((String)originalName);
        String extension = FilenameUtils.getExtension((String)originalName);
        String hash = this.hashStrategy.getHash(inputStream);
        StringBuilder sb = new StringBuilder(baseName).append("-").append(hash);
        if (!StringUtils.isEmpty((CharSequence)extension)) {
            sb.append(".").append(extension);
        }
        return sb.toString();
    }
}

