/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.support;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceAuthorizationManager {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceAuthorizationManager.class);
    private final Set<String> authorizedResources = Collections.synchronizedSet(new HashSet());

    public boolean isAuthorized(String uri) {
        return this.authorizedResources.contains(uri);
    }

    public void add(String uri) {
        Validate.notNull((Object)uri);
        LOG.debug("authorize resource: {}", (Object)uri);
        this.authorizedResources.add(uri);
    }

    public Collection<String> list() {
        return Collections.unmodifiableCollection(this.authorizedResources);
    }

    public void clear() {
        LOG.debug("clear authorized resources.");
        this.authorizedResources.clear();
    }
}

