/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.support;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.resource.processor.support.CSSMin;
import ro.isdc.wro.model.resource.processor.support.Property;

class Selector {
    private static final Logger LOG = LoggerFactory.getLogger(CSSMin.class);
    private final Property[] properties;
    private final String selector;

    public Selector(String selector) throws Exception {
        String[] parts = selector.split("\\{");
        if (parts.length < 2) {
            throw new Exception("Warning: Incomplete selector: " + selector);
        }
        this.selector = parts[0].trim();
        String contents = parts[1].trim();
        if (contents.length() == 0) {
            throw new Exception("Warning: Empty selector body: " + selector);
        }
        if (contents.charAt(contents.length() - 1) != '}') {
            throw new Exception("Warning: Unterminated selector: " + selector);
        }
        contents = contents.substring(0, contents.length() - 2);
        this.properties = this.parseProperties(contents);
        this.sortProperties(this.properties);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.selector).append("{");
        for (Property property : this.properties) {
            if (property == null) continue;
            sb.append(property.toString());
        }
        sb.append("}");
        return sb.toString();
    }

    private Property[] parseProperties(String contents) {
        String[] parts = contents.split(";");
        ArrayList<Property> resultsAsList = new ArrayList<Property>();
        for (int i = 0; i < parts.length; ++i) {
            try {
                String part = parts[i];
                if (StringUtils.isEmpty((CharSequence)part.trim())) continue;
                resultsAsList.add(new Property(part));
                continue;
            }
            catch (Exception e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
        return resultsAsList.toArray(new Property[0]);
    }

    private void sortProperties(Property[] propertiesToSort) {
        Arrays.sort(propertiesToSort);
    }
}

