/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.resource.processor.support.CSSMin;
import ro.isdc.wro.model.resource.processor.support.Value;

class Property
implements Comparable {
    private static final Logger LOG = LoggerFactory.getLogger(CSSMin.class);
    protected String property;
    protected Value[] values;

    public Property(String property) throws Exception {
        try {
            List<String> parts = Arrays.asList(property.split(":", 2));
            ArrayList<String> nonEmptyParts = new ArrayList<String>();
            for (String part : parts) {
                if (StringUtils.isEmpty((CharSequence)part.trim())) continue;
                nonEmptyParts.add(part.trim());
            }
            if (nonEmptyParts.size() < 2) {
                throw new Exception("Warning: Incomplete property: " + property);
            }
            this.property = ((String)nonEmptyParts.get(0)).toLowerCase();
            this.values = this.parseValues(((String)nonEmptyParts.get(1)).replaceAll(", ", ","));
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.property).append(":");
        for (Value v : this.values) {
            sb.append(v.toString()).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(";");
        return sb.toString();
    }

    public int compareTo(Object other) {
        return this.property.compareTo(((Property)other).property);
    }

    private Value[] parseValues(String contents) {
        String[] parts = contents.split(",");
        Value[] results = new Value[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            try {
                results[i] = new Value(parts[i]);
                continue;
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                results[i] = null;
            }
        }
        return results;
    }
}

