/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.impl.css;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.PreProcessorExecutor;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.util.StringUtils;
import ro.isdc.wro.util.WroUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedResourceType(value=ResourceType.CSS)
public class CssImportPreProcessor
implements ResourcePreProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CssImportPreProcessor.class);
    public static final String ALIAS = "cssImport";
    @Inject
    private UriLocatorFactory uriLocatorFactory;
    @Inject
    private PreProcessorExecutor preProcessorExecutor;
    @Inject
    private WroConfiguration configuration;
    private final List<Resource> processed = new ArrayList<Resource>();
    private static final Pattern PATTERN = Pattern.compile(WroUtil.loadRegexpWithKey("cssImport"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        LOG.debug("Applying {} processor", (Object)this.getClass().getSimpleName());
        this.validate();
        try {
            String result = this.parseCss(resource, reader);
            writer.write(result);
            this.processed.clear();
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    private void validate() {
        Validate.notNull((Object)this.uriLocatorFactory);
        Validate.notNull((Object)this.preProcessorExecutor);
    }

    private String parseCss(Resource resource, Reader reader) throws IOException {
        if (this.processed.contains(resource)) {
            LOG.warn("Recursive import detected: " + resource);
            return "";
        }
        this.processed.add(resource);
        StringBuffer sb = new StringBuffer();
        List<Resource> importsCollector = this.getImportedResources(resource);
        sb.append(this.preProcessorExecutor.processAndMerge(importsCollector, true));
        if (!importsCollector.isEmpty()) {
            LOG.debug("Imported resources found : {}", (Object)importsCollector.size());
        }
        sb.append(IOUtils.toString((Reader)reader));
        LOG.debug("importsCollector: {}", importsCollector);
        return this.removeImportStatements(sb.toString());
    }

    private String removeImportStatements(String content) {
        Matcher m = PATTERN.matcher(content);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private List<Resource> getImportedResources(Resource resource) throws IOException {
        String css;
        ArrayList<Resource> imports;
        block4: {
            imports = new ArrayList<Resource>();
            css = "";
            try {
                css = IOUtils.toString((InputStream)this.uriLocatorFactory.locate(resource.getUri()), (String)this.configuration.getEncoding());
            }
            catch (IOException e) {
                LOG.warn("Invalid import detected: {}", (Object)resource.getUri());
                if (this.configuration.isIgnoreMissingResources()) break block4;
                throw e;
            }
        }
        Matcher m = PATTERN.matcher(css);
        while (m.find()) {
            Resource importedResource = this.buildImportedResource(resource, m.group(1));
            if (imports.contains(importedResource)) {
                LOG.warn("Duplicate imported resource: " + importedResource);
                continue;
            }
            imports.add(importedResource);
        }
        return imports;
    }

    private Resource buildImportedResource(Resource resource, String importUrl) {
        String absoluteUrl = this.computeAbsoluteUrl(resource, importUrl);
        return Resource.create(absoluteUrl, ResourceType.CSS);
    }

    private String computeAbsoluteUrl(Resource relativeResource, String importUrl) {
        String folder = FilenameUtils.getFullPath((String)relativeResource.getUri());
        String absoluteImportUrl = StringUtils.cleanPath(folder + importUrl);
        return absoluteImportUrl;
    }
}

